/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class VlanIPRange
implements Comparable<VlanIPRange> {
    private String id;
    private String description;
    @SerializedName(value="forvirtualnetwork")
    private boolean forVirtualNetwork;
    @SerializedName(value="zoneid")
    private String zoneId;
    private String vlan;
    private String account;
    @SerializedName(value="domainid")
    private String domainId;
    private String domain;
    @SerializedName(value="podid")
    private String podId;
    @SerializedName(value="podname")
    private String podName;
    private String gateway;
    private String netmask;
    @SerializedName(value="startip")
    private String startIP;
    @SerializedName(value="endip")
    private String endIP;
    @SerializedName(value="networkid")
    private String networkId;

    public static Builder builder() {
        return new Builder();
    }

    VlanIPRange() {
    }

    public VlanIPRange(String id, String description, boolean forVirtualNetwork, String zoneId, String vlan, String account, String domainId, String domain, String podId, String podName, String gateway, String netmask, String startIP, String endIP, String networkId) {
        this.id = id;
        this.description = description;
        this.forVirtualNetwork = forVirtualNetwork;
        this.zoneId = zoneId;
        this.vlan = vlan;
        this.account = account;
        this.domainId = domainId;
        this.domain = domain;
        this.podId = podId;
        this.podName = podName;
        this.gateway = gateway;
        this.netmask = netmask;
        this.startIP = startIP;
        this.endIP = endIP;
        this.networkId = networkId;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isForVirtualNetwork() {
        return this.forVirtualNetwork;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getVlan() {
        return this.vlan;
    }

    public String getAccount() {
        return this.account;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPodId() {
        return this.podId;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getStartIP() {
        return this.startIP;
    }

    public String getEndIP() {
        return this.endIP;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VlanIPRange that = (VlanIPRange)o;
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.forVirtualNetwork, (Object)that.forVirtualNetwork)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkId, (Object)that.networkId)) {
            return false;
        }
        if (!Objects.equal((Object)this.podId, (Object)that.podId)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.description, (Object)that.description)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.endIP, (Object)that.endIP)) {
            return false;
        }
        if (!Objects.equal((Object)this.gateway, (Object)that.gateway)) {
            return false;
        }
        if (!Objects.equal((Object)this.netmask, (Object)that.netmask)) {
            return false;
        }
        if (!Objects.equal((Object)this.podName, (Object)that.podName)) {
            return false;
        }
        if (!Objects.equal((Object)this.startIP, (Object)that.startIP)) {
            return false;
        }
        return Objects.equal((Object)this.vlan, (Object)that.vlan);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainId, this.forVirtualNetwork, this.id, this.networkId, this.podId, this.zoneId, this.account, this.description, this.domain, this.endIP, this.gateway, this.netmask, this.podName, this.startIP, this.vlan});
    }

    public String toString() {
        return "VlanIPRange{id=" + this.id + ", description='" + this.description + '\'' + ", forVirtualNetwork=" + this.forVirtualNetwork + ", zoneId=" + this.zoneId + ", vlan='" + this.vlan + '\'' + ", account='" + this.account + '\'' + ", domainId=" + this.domainId + ", domain='" + this.domain + '\'' + ", podId=" + this.podId + ", podName='" + this.podName + '\'' + ", gateway='" + this.gateway + '\'' + ", netmask='" + this.netmask + '\'' + ", startIP='" + this.startIP + '\'' + ", endIP='" + this.endIP + '\'' + ", networkId=" + this.networkId + '}';
    }

    @Override
    public int compareTo(VlanIPRange other) {
        return this.id.compareTo(other.id);
    }

    public static class Builder {
        private String id;
        private String description;
        private boolean forVirtualNetwork;
        private String zoneId;
        private String vlan;
        private String account;
        private String domainId;
        private String domain;
        private String podId;
        private String podName;
        private String gateway;
        private String netmask;
        private String startIP;
        private String endIP;
        private String networkId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder forVirtualNetwork(boolean forVirtualNetwork) {
            this.forVirtualNetwork = forVirtualNetwork;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder vlan(String vlan) {
            this.vlan = vlan;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder podId(String podId) {
            this.podId = podId;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Builder startIP(String startIP) {
            this.startIP = startIP;
            return this;
        }

        public Builder endIP(String endIP) {
            this.endIP = endIP;
            return this;
        }

        public Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public VlanIPRange build() {
            return new VlanIPRange(this.id, this.description, this.forVirtualNetwork, this.zoneId, this.vlan, this.account, this.domainId, this.domain, this.podId, this.podName, this.gateway, this.netmask, this.startIP, this.endIP, this.networkId);
        }
    }
}

