/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;
import org.jclouds.cloudstack.domain.VirtualMachine;

public class Volume
implements Comparable<Volume> {
    private String id;
    private String account;
    private Date attached;
    private Date created;
    private boolean destroyed;
    @SerializedName(value="deviceid")
    private String deviceId;
    @SerializedName(value="diskofferingdisplaytext")
    private String diskOfferingDisplayText;
    @SerializedName(value="diskofferingid")
    private String diskOfferingId;
    @SerializedName(value="diskofferingname")
    private String diskOfferingName;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    private String hypervisor;
    @SerializedName(value="isextractable")
    private boolean isExtractable;
    @SerializedName(value="jobid")
    private String jobId;
    @SerializedName(value="jobstatus")
    private String jobStatus;
    private String name;
    @SerializedName(value="serviceofferingdisplaytext")
    private String serviceOfferingDisplayText;
    @SerializedName(value="serviceofferingid")
    private String serviceOfferingId;
    @SerializedName(value="serviceofferingname")
    private String serviceOfferingName;
    private long size;
    @SerializedName(value="snapshotid")
    private String snapshotId;
    private State state;
    private String storage;
    @SerializedName(value="storagetype")
    private String storageType;
    private Type type;
    @SerializedName(value="virtualmachineid")
    private String virtualMachineId;
    @SerializedName(value="vmdisplayname")
    private String vmDisplayName;
    @SerializedName(value="vmname")
    private String vmName;
    @SerializedName(value="vmstate")
    private VirtualMachine.State vmState;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    public Volume(String id, String account, Date attached, Date created, boolean destroyed, String deviceId, String diskOfferingDisplayText, String diskOfferingId, String diskOfferingName, String domain, String domainId, String hypervisor, boolean extractable, String jobId, String jobStatus, String name, String serviceOfferingDisplayText, String serviceOfferingId, String serviceOfferingName, long size, String snapshotId, State state, String storage, String storageType, Type type, String virtualMachineId, String vmDisplayName, String vmName, VirtualMachine.State vmState, String zoneId, String zoneName) {
        this.id = id;
        this.account = account;
        this.attached = attached;
        this.created = created;
        this.destroyed = destroyed;
        this.deviceId = deviceId;
        this.diskOfferingDisplayText = diskOfferingDisplayText;
        this.diskOfferingId = diskOfferingId;
        this.diskOfferingName = diskOfferingName;
        this.domain = domain;
        this.domainId = domainId;
        this.hypervisor = hypervisor;
        this.isExtractable = extractable;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.name = name;
        this.serviceOfferingDisplayText = serviceOfferingDisplayText;
        this.serviceOfferingId = serviceOfferingId;
        this.serviceOfferingName = serviceOfferingName;
        this.size = size;
        this.snapshotId = snapshotId;
        this.state = state;
        this.storage = storage;
        this.storageType = storageType;
        this.type = type;
        this.virtualMachineId = virtualMachineId;
        this.vmDisplayName = vmDisplayName;
        this.vmName = vmName;
        this.vmState = vmState;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    Volume() {
    }

    public String getId() {
        return this.id;
    }

    public Date getAttached() {
        return this.attached;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDiskOfferingDisplayText() {
        return this.diskOfferingDisplayText;
    }

    public String getDiskOfferingId() {
        return this.diskOfferingId;
    }

    public String getDiskOfferingName() {
        return this.diskOfferingName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public boolean isExtractable() {
        return this.isExtractable;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceOfferingDisplayText() {
        return this.serviceOfferingDisplayText;
    }

    public String getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    public String getServiceOfferingName() {
        return this.serviceOfferingName;
    }

    public long getSize() {
        return this.size;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public State getState() {
        return this.state;
    }

    public String getStorage() {
        return this.storage;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public Type getType() {
        return this.type;
    }

    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVmDisplayName() {
        return this.vmDisplayName;
    }

    public String getVmName() {
        return this.vmName;
    }

    public VirtualMachine.State getVmState() {
        return this.vmState;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getAccount() {
        return this.account;
    }

    @Override
    public int compareTo(Volume volume) {
        return this.id.compareTo(volume.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Volume that = (Volume)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.attached, (Object)that.attached)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.destroyed, (Object)that.destroyed)) {
            return false;
        }
        if (!Objects.equal((Object)this.deviceId, (Object)that.deviceId)) {
            return false;
        }
        if (!Objects.equal((Object)this.diskOfferingDisplayText, (Object)that.diskOfferingDisplayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.diskOfferingId, (Object)that.diskOfferingId)) {
            return false;
        }
        if (!Objects.equal((Object)this.diskOfferingName, (Object)that.diskOfferingName)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.hypervisor, (Object)that.hypervisor)) {
            return false;
        }
        if (!Objects.equal((Object)this.isExtractable, (Object)that.isExtractable)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobId, (Object)that.jobId)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobStatus, (Object)that.jobStatus)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.serviceOfferingDisplayText, (Object)that.serviceOfferingDisplayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.serviceOfferingId, (Object)that.serviceOfferingId)) {
            return false;
        }
        if (!Objects.equal((Object)this.serviceOfferingName, (Object)that.serviceOfferingName)) {
            return false;
        }
        if (!Objects.equal((Object)this.size, (Object)that.size)) {
            return false;
        }
        if (!Objects.equal((Object)this.snapshotId, (Object)that.snapshotId)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.state), (Object)((Object)that.state))) {
            return false;
        }
        if (!Objects.equal((Object)this.storage, (Object)that.storage)) {
            return false;
        }
        if (!Objects.equal((Object)this.storageType, (Object)that.storageType)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.type), (Object)((Object)that.type))) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineId, (Object)that.virtualMachineId)) {
            return false;
        }
        if (!Objects.equal((Object)this.vmDisplayName, (Object)that.vmDisplayName)) {
            return false;
        }
        if (!Objects.equal((Object)this.vmName, (Object)that.vmName)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.vmState), (Object)((Object)that.vmState))) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        return Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.attached, this.created, this.destroyed, this.deviceId, this.diskOfferingDisplayText, this.diskOfferingId, this.diskOfferingName, this.domain, this.domainId, this.hypervisor, this.isExtractable, this.jobId, this.jobStatus, this.name, this.serviceOfferingDisplayText, this.serviceOfferingId, this.serviceOfferingName, this.size, this.snapshotId, this.state, this.storage, this.storageType, this.type, this.virtualMachineId, this.vmDisplayName, this.vmName, this.vmState, this.zoneId, this.zoneName});
    }

    public String toString() {
        return "Volume{id=" + this.id + ", account='" + this.account + '\'' + ", attached=" + this.attached + ", created=" + this.created + ", destroyed=" + this.destroyed + ", deviceId=" + this.deviceId + ", diskOfferingDisplayText='" + this.diskOfferingDisplayText + '\'' + ", diskOfferingId=" + this.diskOfferingId + ", diskOfferingName='" + this.diskOfferingName + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", hypervisor='" + this.hypervisor + '\'' + ", isExtractable=" + this.isExtractable + ", jobId=" + this.jobId + ", jobStatus='" + this.jobStatus + '\'' + ", name='" + this.name + '\'' + ", serviceOfferingDisplayText='" + this.serviceOfferingDisplayText + '\'' + ", serviceOfferingId=" + this.serviceOfferingId + ", serviceOfferingName='" + this.serviceOfferingName + '\'' + ", size=" + this.size + ", snapshotId=" + this.snapshotId + ", state=" + (Object)((Object)this.state) + ", storage='" + this.storage + '\'' + ", storageType='" + this.storageType + '\'' + ", type=" + (Object)((Object)this.type) + ", virtualMachineId=" + this.virtualMachineId + ", vmDisplayName='" + this.vmDisplayName + '\'' + ", vmName='" + this.vmName + '\'' + ", vmState=" + (Object)((Object)this.vmState) + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    public static enum Type {
        ROOT(0),
        DATADISK(1),
        UNRECOGNIZED(Integer.MAX_VALUE);

        private int code;
        private static final Map<Integer, Type> INDEX;

        private Type(int code) {
            this.code = code;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static Type fromValue(String resourceType) {
            Integer code = new Integer((String)Preconditions.checkNotNull((Object)resourceType, (Object)"resourcetype"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])Type.values()), (Function)new Function<Type, Integer>(){

                public Integer apply(Type input) {
                    return input.code;
                }
            });
        }
    }

    public static enum State {
        ALLOCATED,
        CREATING,
        READY,
        DESTROYED,
        FAILED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private String id;
        private String account;
        private Date attached;
        private Date created;
        private boolean destroyed;
        private String deviceId;
        private String diskOfferingDisplayText;
        private String diskOfferingId;
        private String diskOfferingName;
        private String domain;
        private String domainId;
        private String hypervisor;
        private boolean isExtractable;
        private String jobId;
        private String jobStatus;
        private String name;
        private String serviceOfferingDisplayText;
        private String serviceOfferingId;
        private String serviceOfferingName;
        private long size;
        private String snapshotId;
        private State state;
        private String storage;
        private String storageType;
        private Type type;
        private String virtualMachineId;
        private String vmDisplayName;
        private String vmName;
        private VirtualMachine.State vmState;
        private String zoneId;
        private String zoneName;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder attached(Date attached) {
            this.attached = attached;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder destroyed(boolean destroyed) {
            this.destroyed = destroyed;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder diskOfferingDisplayText(String diskOfferingDisplayText) {
            this.diskOfferingDisplayText = diskOfferingDisplayText;
            return this;
        }

        public Builder diskOfferingId(String diskOfferingId) {
            this.diskOfferingId = diskOfferingId;
            return this;
        }

        public Builder diskOfferingName(String diskOfferingName) {
            this.diskOfferingName = diskOfferingName;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder isExtractable(boolean isExtractable) {
            this.isExtractable = isExtractable;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder serviceOfferingDisplayText(String serviceOfferingDisplayText) {
            this.serviceOfferingDisplayText = serviceOfferingDisplayText;
            return this;
        }

        public Builder serviceOfferingId(String serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this;
        }

        public Builder serviceOfferingName(String serviceOfferingName) {
            this.serviceOfferingName = serviceOfferingName;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder storage(String storage) {
            this.storage = storage;
            return this;
        }

        public Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder vmDisplayName(String vmDisplayName) {
            this.vmDisplayName = vmDisplayName;
            return this;
        }

        public Builder vmName(String vmName) {
            this.vmName = vmName;
            return this;
        }

        public Builder vmState(VirtualMachine.State vmState) {
            this.vmState = vmState;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Volume build() {
            return new Volume(this.id, this.account, this.attached, this.created, this.destroyed, this.deviceId, this.diskOfferingDisplayText, this.diskOfferingId, this.diskOfferingName, this.domain, this.domainId, this.hypervisor, this.isExtractable, this.jobId, this.jobStatus, this.name, this.serviceOfferingDisplayText, this.serviceOfferingId, this.serviceOfferingName, this.size, this.snapshotId, this.state, this.storage, this.storageType, this.type, this.virtualMachineId, this.vmDisplayName, this.vmName, this.vmState, this.zoneId, this.zoneName);
        }
    }
}

