/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.NetworkType;

public class Zone
implements Comparable<Zone> {
    private String id;
    private String description;
    @SerializedName(value="displaytext")
    private String displayText;
    @SerializedName(value="dns1")
    private String DNS1;
    @SerializedName(value="dns2")
    private String DNS2;
    private String domain;
    @Nullable
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="guestcidraddress")
    private String guestCIDRAddress;
    @SerializedName(value="internaldns1")
    private String internalDNS1;
    @SerializedName(value="internaldns2")
    private String internalDNS2;
    private String name;
    @SerializedName(value="networktype")
    private NetworkType networkType;
    @SerializedName(value="vlan")
    private String VLAN;
    @SerializedName(value="securitygroupsenabled")
    private boolean securityGroupsEnabled;
    @SerializedName(value="allocationstate")
    private AllocationState allocationState;
    @SerializedName(value="dhcpprovider")
    private String dhcpProvider;
    @SerializedName(value="zonetoken")
    private String zoneToken;

    public static Builder builder() {
        return new Builder();
    }

    Zone() {
    }

    public Zone(String id, String description, String displayText, List<String> DNS, String domain, String domainId, String guestCIDRAddress, List<String> internalDNS, String name, NetworkType networkType, String vLAN, boolean securityGroupsEnabled, AllocationState allocationState, String dhcpProvider, String zoneToken) {
        this.id = id;
        this.description = description;
        this.displayText = displayText;
        this.DNS1 = ((List)Preconditions.checkNotNull(DNS, (Object)"DNS")).size() > 0 ? DNS.get(0) : null;
        this.DNS2 = DNS.size() > 1 ? DNS.get(1) : null;
        this.domain = domain;
        this.domainId = domainId;
        this.guestCIDRAddress = guestCIDRAddress;
        this.internalDNS1 = ((List)Preconditions.checkNotNull(internalDNS, (Object)"internalDNS")).size() > 0 ? internalDNS.get(0) : null;
        this.internalDNS2 = internalDNS.size() > 1 ? internalDNS.get(1) : null;
        this.name = name;
        this.networkType = networkType;
        this.VLAN = vLAN;
        this.securityGroupsEnabled = securityGroupsEnabled;
        this.allocationState = allocationState;
        this.dhcpProvider = dhcpProvider;
        this.zoneToken = zoneToken;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public List<String> getDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.DNS1 != null && !"".equals(this.DNS1)) {
            builder.add((Object)this.DNS1);
        }
        if (this.DNS2 != null && !"".equals(this.DNS2)) {
            builder.add((Object)this.DNS2);
        }
        return builder.build();
    }

    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public String getGuestCIDRAddress() {
        return this.guestCIDRAddress;
    }

    public List<String> getInternalDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.internalDNS1 != null && !"".equals(this.internalDNS1)) {
            builder.add((Object)this.internalDNS1);
        }
        if (this.internalDNS2 != null && !"".equals(this.internalDNS2)) {
            builder.add((Object)this.internalDNS2);
        }
        return builder.build();
    }

    public String getName() {
        return this.name;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getVLAN() {
        return this.VLAN;
    }

    public boolean isSecurityGroupsEnabled() {
        return this.securityGroupsEnabled;
    }

    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public String getDhcpProvider() {
        return this.dhcpProvider;
    }

    public String getZoneToken() {
        return this.zoneToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Zone that = (Zone)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.description, (Object)that.description)) {
            return false;
        }
        if (!Objects.equal((Object)this.displayText, (Object)that.displayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.DNS1, (Object)that.DNS1)) {
            return false;
        }
        if (!Objects.equal((Object)this.DNS2, (Object)that.DNS2)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.guestCIDRAddress, (Object)that.guestCIDRAddress)) {
            return false;
        }
        if (!Objects.equal((Object)this.internalDNS1, (Object)that.internalDNS1)) {
            return false;
        }
        if (!Objects.equal((Object)this.internalDNS2, (Object)that.internalDNS2)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.networkType), (Object)((Object)that.networkType))) {
            return false;
        }
        if (!Objects.equal((Object)this.VLAN, (Object)that.VLAN)) {
            return false;
        }
        if (!Objects.equal((Object)this.securityGroupsEnabled, (Object)that.securityGroupsEnabled)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.allocationState), (Object)((Object)that.allocationState))) {
            return false;
        }
        if (!Objects.equal((Object)this.dhcpProvider, (Object)that.dhcpProvider)) {
            return false;
        }
        return Objects.equal((Object)this.zoneToken, (Object)that.zoneToken);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.description, this.displayText, this.DNS1, this.DNS2, this.domain, this.domainId, this.guestCIDRAddress, this.internalDNS1, this.internalDNS2, this.name, this.networkType, this.VLAN, this.securityGroupsEnabled, this.allocationState, this.dhcpProvider, this.zoneToken});
    }

    public String toString() {
        return "Zone{id=" + this.id + ", description='" + this.description + '\'' + ", displayText='" + this.displayText + '\'' + ", DNS1='" + this.DNS1 + '\'' + ", DNS2='" + this.DNS2 + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", guestCIDRAddress='" + this.guestCIDRAddress + '\'' + ", internalDNS1='" + this.internalDNS1 + '\'' + ", internalDNS2='" + this.internalDNS2 + '\'' + ", name='" + this.name + '\'' + ", networkType=" + (Object)((Object)this.networkType) + ", VLAN='" + this.VLAN + '\'' + ", securityGroupsEnabled=" + this.securityGroupsEnabled + ", allocationState='" + (Object)((Object)this.allocationState) + '\'' + ", dhcpProvider='" + this.dhcpProvider + '\'' + ", zoneToken='" + this.zoneToken + '\'' + '}';
    }

    @Override
    public int compareTo(Zone arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public static class Builder {
        private String id;
        private String description;
        private String displayText;
        private List<String> DNS = ImmutableList.of();
        private String domain;
        private String domainId;
        private String guestCIDRAddress;
        private List<String> internalDNS = ImmutableList.of();
        private String name;
        private NetworkType networkType;
        private String VLAN;
        private boolean securityGroupsEnabled;
        private AllocationState allocationState;
        private String dhcpProvider;
        private String zoneToken;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder DNS(List<String> DNS) {
            this.DNS = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(DNS, (Object)"DNS")));
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder guestCIDRAddress(String guestCIDRAddress) {
            this.guestCIDRAddress = guestCIDRAddress;
            return this;
        }

        public Builder internalDNS(List<String> internalDNS) {
            this.internalDNS = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(internalDNS, (Object)"internalDNS")));
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            return this;
        }

        public Builder VLAN(String VLAN) {
            this.VLAN = VLAN;
            return this;
        }

        public Builder securityGroupsEnabled(boolean securityGroupsEnabled) {
            this.securityGroupsEnabled = securityGroupsEnabled;
            return this;
        }

        public Builder allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this;
        }

        public Builder dhcpProvider(String dhcpProvider) {
            this.dhcpProvider = dhcpProvider;
            return this;
        }

        public Builder zoneToken(String zoneToken) {
            this.zoneToken = zoneToken;
            return this;
        }

        public Zone build() {
            return new Zone(this.id, this.description, this.displayText, this.DNS, this.domain, this.domainId, this.guestCIDRAddress, this.internalDNS, this.name, this.networkType, this.VLAN, this.securityGroupsEnabled, this.allocationState, this.dhcpProvider, this.zoneToken);
        }
    }
}

