/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.NetworkClient;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.collect.Memoized;

public class NetworksForCurrentUser
implements Supplier<Map<String, Network>> {
    private final CloudStackClient client;
    private final Supplier<User> currentUserSupplier;

    @Inject
    public NetworksForCurrentUser(CloudStackClient client, @Memoized Supplier<User> currentUserSupplier) {
        this.client = (CloudStackClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.currentUserSupplier = (Supplier)Preconditions.checkNotNull(currentUserSupplier, (Object)"currentUserSupplier");
    }

    public Map<String, Network> get() {
        User currentUser = (User)this.currentUserSupplier.get();
        NetworkClient networkClient = this.client.getNetworkClient();
        return Maps.uniqueIndex(networkClient.listNetworks(ListNetworksOptions.Builder.accountInDomain(currentUser.getAccount(), currentUser.getDomainId())), (Function)new Function<Network, String>(){

            public String apply(Network arg0) {
                return arg0.getId();
            }
        });
    }
}

