/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BindAuthToJsonPayload
extends BindToJsonPayload
implements MapBinder {
    @Inject
    public BindAuthToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("BindAuthToJsonPayload needs parameters");
    }

    protected void addCredentialsInArgsOrNull(GeneratedHttpRequest<?> gRequest, ImmutableMap.Builder<String, Object> builder) {
        for (Object arg : Iterables.filter((Iterable)gRequest.getArgs(), (Predicate)Predicates.notNull())) {
            if (!arg.getClass().isAnnotationPresent(CredentialType.class)) continue;
            builder.put((Object)arg.getClass().getAnnotation(CredentialType.class).value(), arg);
        }
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState((gRequest.getArgs() != null ? 1 : 0) != 0, (Object)"args should be initialized at this point");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.addCredentialsInArgsOrNull(gRequest, (ImmutableMap.Builder<String, Object>)builder);
        if (!Strings.isNullOrEmpty((String)((String)postParams.get("tenantName")))) {
            builder.put((Object)"tenantName", postParams.get("tenantName"));
        } else if (!Strings.isNullOrEmpty((String)((String)postParams.get("tenantId")))) {
            builder.put((Object)"tenantId", postParams.get("tenantId"));
        }
        return (R)super.bindToRequest(request, (Object)ImmutableMap.of((Object)"auth", (Object)builder.build()));
    }
}

