/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@SkipEncoding(value={47, 61})
@Endpoint(value=Identity.class)
public interface TokenAsyncClient {
    @GET
    @SelectJson(value="token")
    @Consumes(value={"application/json"})
    @Path(value="/tokens/{token}")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Token> get(@PathParam(value="token") String var1);

    @GET
    @SelectJson(value="user")
    @Consumes(value={"application/json"})
    @Path(value="/tokens/{token}")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<User> getUserOfToken(@PathParam(value="token") String var1);

    @HEAD
    @Path(value="/tokens/{token}")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> isValid(@PathParam(value="token") String var1);

    @GET
    @SelectJson(value="endpoints")
    @Consumes(value={"application/json"})
    @Path(value="/tokens/{token}/endpoints")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<org.jclouds.openstack.keystone.v2_0.domain.Endpoint>> listEndpointsForToken(@PathParam(value="token") String var1);
}

