/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Endpoint(value=Identity.class)
@SkipEncoding(value={47, 61})
public interface UserAsyncClient {
    @GET
    @SelectJson(value="users")
    @Consumes(value={"application/json"})
    @Path(value="/users")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<User>> list();

    @GET
    @SelectJson(value="user")
    @Consumes(value={"application/json"})
    @Path(value="/users/{userId}")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<User> get(@PathParam(value="userId") String var1);

    @GET
    @SelectJson(value="user")
    @Consumes(value={"application/json"})
    @Path(value="/users")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<User> getByName(@QueryParam(value="name") String var1);

    @GET
    @SelectJson(value="roles")
    @Consumes(value={"application/json"})
    @Path(value="/users/{userId}/roles")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Role>> listRolesOfUser(@PathParam(value="userId") String var1);

    @GET
    @SelectJson(value="roles")
    @Consumes(value={"application/json"})
    @Path(value="/tenants/{tenantId}/users/{userId}/roles")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Role>> listRolesOfUserOnTenant(@PathParam(value="userId") String var1, @PathParam(value="tenantId") String var2);
}

