/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1;

import com.google.common.base.Optional;
import com.google.inject.Provides;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.concurrent.Timeout;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Zone;
import org.jclouds.location.functions.ZoneToEndpoint;
import org.jclouds.openstack.nova.v1_1.extensions.FloatingIPClient;
import org.jclouds.openstack.nova.v1_1.extensions.KeyPairClient;
import org.jclouds.openstack.nova.v1_1.extensions.SecurityGroupClient;
import org.jclouds.openstack.nova.v1_1.features.ExtensionClient;
import org.jclouds.openstack.nova.v1_1.features.FlavorClient;
import org.jclouds.openstack.nova.v1_1.features.ImageClient;
import org.jclouds.openstack.nova.v1_1.features.ServerClient;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;

@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface NovaClient {
    @Provides
    @Zone
    public Set<String> getConfiguredZones();

    @Delegate
    public ServerClient getServerClientForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public FlavorClient getFlavorClientForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public ExtensionClient getExtensionClientForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public ImageClient getImageClientForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<FloatingIPClient> getFloatingIPExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<SecurityGroupClient> getSecurityGroupExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<KeyPairClient> getKeyPairExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);
}

