/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v1_1.NovaClient;
import org.jclouds.openstack.nova.v1_1.domain.Ingress;
import org.jclouds.openstack.nova.v1_1.domain.IpProtocol;
import org.jclouds.openstack.nova.v1_1.domain.SecurityGroup;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ZoneSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v1_1.extensions.SecurityGroupClient;
import org.jclouds.openstack.nova.v1_1.predicates.SecurityGroupPredicates;

@Singleton
public class CreateSecurityGroupIfNeeded
implements Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaClient novaClient;

    @Inject
    public CreateSecurityGroupIfNeeded(NovaClient novaClient) {
        this.novaClient = (NovaClient)Preconditions.checkNotNull((Object)novaClient, (Object)"novaClient");
    }

    public SecurityGroupInZone apply(ZoneSecurityGroupNameAndPorts zoneSecurityGroupNameAndPorts) {
        Preconditions.checkNotNull((Object)zoneSecurityGroupNameAndPorts, (Object)"zoneSecurityGroupNameAndPorts");
        String zoneId = zoneSecurityGroupNameAndPorts.getZone();
        Optional<SecurityGroupClient> client = this.novaClient.getSecurityGroupExtensionForZone(zoneId);
        Preconditions.checkArgument((boolean)client.isPresent(), (String)"Security groups are required, but the extension is not availablein zone %s!", (Object[])new Object[]{zoneId});
        this.logger.debug(">> creating securityGroup %s", new Object[]{zoneSecurityGroupNameAndPorts});
        try {
            SecurityGroup securityGroup = ((SecurityGroupClient)client.get()).createSecurityGroupWithNameAndDescription(zoneSecurityGroupNameAndPorts.getName(), zoneSecurityGroupNameAndPorts.getName());
            this.logger.debug("<< created securityGroup(%s)", new Object[]{securityGroup});
            for (int port : zoneSecurityGroupNameAndPorts.getPorts()) {
                this.authorizeGroupToItselfAndAllIPsToTCPPort((SecurityGroupClient)client.get(), securityGroup, port);
            }
            return new SecurityGroupInZone(((SecurityGroupClient)client.get()).getSecurityGroup(securityGroup.getId()), zoneId);
        }
        catch (IllegalStateException e) {
            this.logger.trace("<< trying to find securityGroup(%s): %s", new Object[]{zoneSecurityGroupNameAndPorts, e.getMessage()});
            SecurityGroup group = (SecurityGroup)Iterables.find(((SecurityGroupClient)client.get()).listSecurityGroups(), SecurityGroupPredicates.nameEquals(zoneSecurityGroupNameAndPorts.getName()));
            this.logger.debug("<< reused securityGroup(%s)", new Object[]{group.getId()});
            return new SecurityGroupInZone(group, zoneId);
        }
    }

    private void authorizeGroupToItselfAndAllIPsToTCPPort(SecurityGroupClient securityGroupClient, SecurityGroup securityGroup, int port) {
        this.logger.debug(">> authorizing securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, port});
        securityGroupClient.createSecurityGroupRuleAllowingCidrBlock(securityGroup.getId(), Ingress.builder().ipProtocol(IpProtocol.TCP).fromPort(port).toPort(port).build(), "0.0.0.0/0");
        this.logger.debug("<< authorized securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, port});
    }
}

