/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v1_1.NovaClient;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v1_1.extensions.FloatingIPClient;

public class RemoveFloatingIpFromNodeAndDeallocate
implements Function<ZoneAndId, ZoneAndId> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final NovaClient novaClient;
    private final LoadingCache<ZoneAndId, Iterable<String>> floatingIpCache;

    @Inject
    public RemoveFloatingIpFromNodeAndDeallocate(NovaClient novaClient, @Named(value="FLOATINGIP") LoadingCache<ZoneAndId, Iterable<String>> floatingIpCache) {
        this.novaClient = (NovaClient)Preconditions.checkNotNull((Object)novaClient, (Object)"novaClient");
        this.floatingIpCache = (LoadingCache)Preconditions.checkNotNull(floatingIpCache, (Object)"floatingIpCache");
    }

    public ZoneAndId apply(ZoneAndId id) {
        FloatingIPClient floatingIpClient = (FloatingIPClient)this.novaClient.getFloatingIPExtensionForZone(id.getZone()).get();
        for (String ip : (Iterable)this.floatingIpCache.getUnchecked((Object)id)) {
            this.logger.debug(">> removing floatingIp(%s) from node(%s)", new Object[]{ip, id});
            floatingIpClient.removeFloatingIPFromServer(ip, id.getId());
            this.logger.debug(">> deallocating floatingIp(%s)", new Object[]{ip});
            floatingIpClient.deallocate(ip);
        }
        this.floatingIpCache.invalidate((Object)id);
        return id;
    }

    public String toString() {
        return Objects.toStringHelper((String)"RemoveFloatingIpFromNodeAndDeallocate").toString();
    }
}

