/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.nova.v1_1.NovaClient;
import org.jclouds.openstack.nova.v1_1.domain.FloatingIP;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v1_1.extensions.FloatingIPClient;

@Singleton
public class LoadFloatingIpsForInstance
extends CacheLoader<ZoneAndId, Iterable<String>> {
    private final NovaClient client;

    @Inject
    public LoadFloatingIpsForInstance(NovaClient client) {
        this.client = client;
    }

    public Iterable<String> load(final ZoneAndId key) throws Exception {
        String zone = key.getZone();
        Optional<FloatingIPClient> ipClientOptional = this.client.getFloatingIPExtensionForZone(zone);
        if (ipClientOptional.isPresent()) {
            return Iterables.transform((Iterable)Iterables.filter(((FloatingIPClient)ipClientOptional.get()).listFloatingIPs(), (Predicate)new Predicate<FloatingIP>(){

                public boolean apply(FloatingIP input) {
                    return key.getId().equals(input.getInstanceId());
                }
            }), (Function)new Function<FloatingIP, String>(){

                public String apply(FloatingIP input) {
                    return input.getIp();
                }
            });
        }
        return ImmutableSet.of();
    }
}

