/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;

public class Address {
    protected final String addr;
    protected final int version;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Address.builder().fromAddress(this);
    }

    public static Address createV4(String addr) {
        return Address.builder().version(4).addr(addr).build();
    }

    public static Address createV6(String addr) {
        return Address.builder().version(6).addr(addr).build();
    }

    public Address(String addr, int version) {
        this.addr = addr;
        this.version = version;
    }

    public String getAddr() {
        return this.addr;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Address) {
            Address other = (Address)Address.class.cast(object);
            return Objects.equal((Object)this.addr, (Object)other.addr) && Objects.equal((Object)this.version, (Object)other.version);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.addr, this.version});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("addr", (Object)this.addr).add("version", this.version).toString();
    }

    public static class Builder {
        protected String addr;
        protected int version;

        protected Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder addr(String addr) {
            this.addr = addr;
            return this;
        }

        public Address build() {
            return new Address(this.addr, this.version);
        }

        public Builder fromAddress(Address from) {
            return this.addr(from.getAddr()).version(from.getVersion());
        }
    }

    public static enum Type {
        INTERNET,
        PUBLIC,
        PRIVATE,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static Type fromValue(String v) {
            try {
                return Type.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

