/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import java.util.Set;
import org.jclouds.openstack.domain.Link;
import org.jclouds.openstack.domain.Resource;

public class Flavor
extends Resource {
    private int ram;
    private int disk;
    private int vcpus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Flavor.builder().fromFlavor(this);
    }

    protected Flavor(String id, String name, Set<Link> links, int ram, int disk, int vcpus) {
        super(id, name, links);
        this.ram = ram;
        this.disk = disk;
        this.vcpus = vcpus;
    }

    public int getRam() {
        return this.ram;
    }

    public int getDisk() {
        return this.disk;
    }

    public int getVcpus() {
        return this.vcpus;
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("name", (Object)this.name).add("links", (Object)this.links).add("ram", this.ram).add("disk", this.disk).add("vcpus", this.vcpus).toString();
    }

    public static class Builder
    extends Resource.Builder {
        private int ram;
        private int disk;
        private int vcpus;

        public Builder ram(int ram) {
            this.ram = ram;
            return this;
        }

        public Builder disk(int disk) {
            this.disk = disk;
            return this;
        }

        public Builder vcpus(int vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public Flavor build() {
            return new Flavor(this.id, this.name, this.links, this.ram, this.disk, this.vcpus);
        }

        public Builder fromFlavor(Flavor in) {
            return this.fromResource(in).ram(in.getRam()).disk(in.getDisk()).vcpus(in.getVcpus());
        }

        public Builder id(String id) {
            return (Builder)((Object)Builder.class.cast(super.id(id)));
        }

        public Builder name(String name) {
            return (Builder)((Object)Builder.class.cast(super.name(name)));
        }

        public Builder links(Set<Link> links) {
            return (Builder)((Object)Builder.class.cast(super.links(links)));
        }

        public Builder fromResource(Resource in) {
            return (Builder)((Object)Builder.class.cast(super.fromResource(in)));
        }
    }
}

