/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.extensions;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v1_1.binders.BindSecurityGroupRuleToJsonPayload;
import org.jclouds.openstack.nova.v1_1.domain.Ingress;
import org.jclouds.openstack.nova.v1_1.domain.SecurityGroup;
import org.jclouds.openstack.nova.v1_1.domain.SecurityGroupRule;
import org.jclouds.openstack.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/securitygroups/api/v1.1")
@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface SecurityGroupAsyncClient {
    @GET
    @SelectJson(value="security_groups")
    @Consumes(value={"application/json"})
    @Path(value="/os-security-groups")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<SecurityGroup>> listSecurityGroups();

    @GET
    @Path(value="/os-security-groups/{id}")
    @SelectJson(value="security_group")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<SecurityGroup> getSecurityGroup(@PathParam(value="id") String var1);

    @POST
    @Path(value="/os-security-groups")
    @SelectJson(value="security_group")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Payload(value="%7B\"security_group\":%7B\"name\":\"{name}\",\"description\":\"{description}\"%7D%7D")
    public ListenableFuture<SecurityGroup> createSecurityGroupWithNameAndDescription(@PayloadParam(value="name") String var1, @PayloadParam(value="description") String var2);

    @DELETE
    @Path(value="/os-security-groups/{id}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    public ListenableFuture<Boolean> deleteSecurityGroup(@PathParam(value="id") String var1);

    @POST
    @Path(value="/os-security-group-rules")
    @SelectJson(value="security_group_rule")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindSecurityGroupRuleToJsonPayload.class)
    public ListenableFuture<SecurityGroupRule> createSecurityGroupRuleAllowingCidrBlock(@PayloadParam(value="parent_group_id") String var1, Ingress var2, @PayloadParam(value="cidr") String var3);

    @POST
    @Path(value="/os-security-group-rules")
    @SelectJson(value="security_group_rule")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindSecurityGroupRuleToJsonPayload.class)
    public ListenableFuture<SecurityGroupRule> createSecurityGroupRuleAllowingSecurityGroupId(@PayloadParam(value="parent_group_id") String var1, Ingress var2, @PayloadParam(value="group_id") String var3);

    @DELETE
    @Path(value="/os-security-group-rules/{security_group_rule_ID}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @Consumes
    public ListenableFuture<Boolean> deleteSecurityGroupRule(@PathParam(value="security_group_rule_ID") String var1);
}

