/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.openstack.domain.Resource;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v1_1.domain.Image;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface ImageAsyncClient {
    @GET
    @SelectJson(value="images")
    @Consumes(value={"application/json"})
    @Path(value="/images")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Resource>> listImages();

    @GET
    @SelectJson(value="images")
    @Consumes(value={"application/json"})
    @Path(value="/images/detail")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Image>> listImagesInDetail();

    @GET
    @SelectJson(value="image")
    @Consumes(value={"application/json"})
    @Path(value="/images/{id}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Image> getImage(@PathParam(value="id") String var1);

    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/images/{id}")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteImage(@PathParam(value="id") String var1);
}

