/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class RebuildServerOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    String imageRef;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        HashMap image = Maps.newHashMap();
        if (this.imageRef != null) {
            image.put("imageRef", this.imageRef);
        }
        return (R)this.jsonBinder.bindToRequest(request, (Object)ImmutableMap.of((Object)"rebuild", (Object)image));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("RebuildServer is a POST operation");
    }

    public RebuildServerOptions withImage(String ref) {
        Preconditions.checkNotNull((Object)ref, (Object)"image reference should not be null");
        Preconditions.checkArgument((!ref.isEmpty() ? 1 : 0) != 0, (Object)"image reference should not be empty");
        this.imageRef = ref;
        return this;
    }

    public static class Builder {
        public static RebuildServerOptions withImage(String ref) {
            RebuildServerOptions options = new RebuildServerOptions();
            return options.withImage(ref);
        }
    }
}

