/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.predicates;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v1_1.NovaClient;
import org.jclouds.openstack.nova.v1_1.domain.SecurityGroup;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v1_1.extensions.SecurityGroupClient;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class FindSecurityGroupWithNameAndReturnTrue
implements Predicate<AtomicReference<ZoneAndName>> {
    private final NovaClient novaClient;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public FindSecurityGroupWithNameAndReturnTrue(NovaClient novaClient) {
        this.novaClient = (NovaClient)Preconditions.checkNotNull((Object)novaClient, (Object)"novaClient");
    }

    public boolean apply(AtomicReference<ZoneAndName> securityGroupInZoneRef) {
        Preconditions.checkNotNull(securityGroupInZoneRef, (Object)"securityGroupRef");
        final ZoneAndName securityGroupInZone = (ZoneAndName)Preconditions.checkNotNull((Object)securityGroupInZoneRef.get(), (Object)"securityGroupInZone");
        Optional<SecurityGroupClient> client = this.novaClient.getSecurityGroupExtensionForZone(securityGroupInZone.getZone());
        Preconditions.checkArgument((boolean)client.isPresent(), (Object)"Security groups are required, but the extension is not available!");
        this.logger.trace("looking for security group %s", new Object[]{securityGroupInZone.slashEncode()});
        try {
            SecurityGroup returnVal = (SecurityGroup)Iterables.find(((SecurityGroupClient)client.get()).listSecurityGroups(), (Predicate)new Predicate<SecurityGroup>(){

                public boolean apply(SecurityGroup input) {
                    return input.getName().equals(securityGroupInZone.getName());
                }
            });
            securityGroupInZoneRef.set(new SecurityGroupInZone(returnVal, securityGroupInZone.getZone()));
            return true;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

