/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.Zone;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.RemoveFloatingIpFromNodeAndDeallocate;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.RebootType;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.FlavorInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ImageInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ServerInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.extensions.ServerAdminApi;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;
import org.jclouds.openstack.nova.v2_0.predicates.ImagePredicates;

public class NovaComputeServiceAdapter
implements ComputeServiceAdapter<ServerInZone, FlavorInZone, ImageInZone, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;
    protected final Supplier<Set<String>> zoneIds;
    protected final RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate;
    protected final LoadingCache<ZoneAndName, KeyPair> keyPairCache;

    @Inject
    public NovaComputeServiceAdapter(NovaApi novaApi, @Zone Supplier<Set<String>> zoneIds, RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate, LoadingCache<ZoneAndName, KeyPair> keyPairCache) {
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
        this.zoneIds = (Supplier)Preconditions.checkNotNull(zoneIds, (Object)"zoneIds");
        this.removeFloatingIpFromNodeAndDeallocate = (RemoveFloatingIpFromNodeAndDeallocate)Preconditions.checkNotNull((Object)removeFloatingIpFromNodeAndDeallocate, (Object)"removeFloatingIpFromNodeAndDeallocate");
        this.keyPairCache = (LoadingCache)Preconditions.checkNotNull(keyPairCache, (Object)"keyPairCache");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerInZone> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder();
        NovaTemplateOptions templateOptions = (NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class);
        CreateServerOptions options = new CreateServerOptions();
        options.metadata(ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue((TemplateOptions)template.getOptions()));
        options.securityGroupNames(templateOptions.getSecurityGroupNames());
        options.userData(templateOptions.getUserData());
        Optional privateKey = Optional.absent();
        if (templateOptions.getKeyPairName() != null) {
            options.keyPairName(templateOptions.getKeyPairName());
            KeyPair keyPair = (KeyPair)this.keyPairCache.getIfPresent((Object)ZoneAndName.fromZoneAndName(template.getLocation().getId(), templateOptions.getKeyPairName()));
            if (keyPair != null && keyPair.getPrivateKey() != null) {
                privateKey = Optional.of((Object)keyPair.getPrivateKey());
                credentialsBuilder.privateKey((String)privateKey.get());
            }
        }
        String zoneId = template.getLocation().getId();
        String imageId = template.getImage().getProviderId();
        String flavorId = template.getHardware().getProviderId();
        this.logger.debug(">> creating new server zone(%s) name(%s) image(%s) flavor(%s) options(%s)", new Object[]{zoneId, name, imageId, flavorId, options});
        ServerCreated lightweightServer = this.novaApi.getServerApiForZone(zoneId).create(name, imageId, flavorId, options);
        Server server = this.novaApi.getServerApiForZone(zoneId).get(lightweightServer.getId());
        this.logger.trace("<< server(%s)", new Object[]{server.getId()});
        ServerInZone serverInZone = new ServerInZone(server, zoneId);
        if (!privateKey.isPresent()) {
            credentialsBuilder.password(lightweightServer.getAdminPass());
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)serverInZone, serverInZone.slashEncode(), credentialsBuilder.build());
    }

    public Iterable<FlavorInZone> listHardwareProfiles() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String zoneId : (Set)this.zoneIds.get()) {
            builder.addAll(Iterables.transform((Iterable)this.novaApi.getFlavorApiForZone(zoneId).listInDetail().concat(), (Function)new Function<Flavor, FlavorInZone>(){

                public FlavorInZone apply(Flavor arg0) {
                    return new FlavorInZone(arg0, zoneId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<ImageInZone> listImages() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set zones = (Set)this.zoneIds.get();
        Preconditions.checkState((zones.size() > 0 ? 1 : 0) != 0, (String)"no zones found in supplier %s", (Object[])new Object[]{this.zoneIds});
        for (final String zoneId : zones) {
            ImmutableSet images = this.novaApi.getImageApiForZone(zoneId).listInDetail().concat().toImmutableSet();
            if (images.size() == 0) {
                this.logger.debug("no images found in zone %s", new Object[]{zoneId});
                continue;
            }
            Iterable active = Iterables.filter((Iterable)images, ImagePredicates.statusEquals(Image.Status.ACTIVE));
            if (images.size() == 0) {
                this.logger.debug("no images with status active in zone %s; non-active: %s", new Object[]{zoneId, Iterables.transform((Iterable)active, (Function)new Function<Image, String>(){

                    public String apply(Image input) {
                        return Objects.toStringHelper((String)"").add("id", (Object)input.getId()).add("status", (Object)input.getStatus()).toString();
                    }
                })});
                continue;
            }
            builder.addAll(Iterables.transform((Iterable)active, (Function)new Function<Image, ImageInZone>(){

                public ImageInZone apply(Image arg0) {
                    return new ImageInZone(arg0, zoneId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<ServerInZone> listNodes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String zoneId : (Set)this.zoneIds.get()) {
            builder.addAll((Iterable)this.novaApi.getServerApiForZone(zoneId).listInDetail().concat().transform((Function)new Function<Server, ServerInZone>(){

                public ServerInZone apply(Server arg0) {
                    return new ServerInZone(arg0, zoneId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public ServerInZone getNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        Server server = this.novaApi.getServerApiForZone(zoneAndId.getZone()).get(zoneAndId.getId());
        return server == null ? null : new ServerInZone(server, zoneAndId.getZone());
    }

    public ImageInZone getImage(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        Image image = this.novaApi.getImageApiForZone(zoneAndId.getZone()).get(zoneAndId.getId());
        return image == null ? null : new ImageInZone(image, zoneAndId.getZone());
    }

    public void destroyNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        if (this.novaApi.getFloatingIPExtensionForZone(zoneAndId.getZone()).isPresent()) {
            try {
                this.removeFloatingIpFromNodeAndDeallocate.apply(zoneAndId);
            }
            catch (RuntimeException e) {
                this.logger.warn((Throwable)e, "<< error removing and deallocating ip from node(%s): %s", new Object[]{id, e.getMessage()});
            }
        }
        this.novaApi.getServerApiForZone(zoneAndId.getZone()).delete(zoneAndId.getId());
    }

    public void rebootNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        this.novaApi.getServerApiForZone(zoneAndId.getZone()).reboot(zoneAndId.getId(), RebootType.HARD);
    }

    public void resumeNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        if (this.novaApi.getServerAdminExtensionForZone(zoneAndId.getZone()).isPresent()) {
            ((ServerAdminApi)this.novaApi.getServerAdminExtensionForZone(zoneAndId.getZone()).get()).resume(zoneAndId.getId());
        }
        throw new UnsupportedOperationException("resume requires installation of the Admin Actions extension");
    }

    public void suspendNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        if (this.novaApi.getServerAdminExtensionForZone(zoneAndId.getZone()).isPresent()) {
            ((ServerAdminApi)this.novaApi.getServerAdminExtensionForZone(zoneAndId.getZone()).get()).suspend(zoneAndId.getId());
        }
        throw new UnsupportedOperationException("suspend requires installation of the Admin Actions extension");
    }
}

