/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;
import org.jclouds.rest.InsufficientResourcesException;

public class AllocateAndAddFloatingIpToNode
implements Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    private final NovaApi novaApi;
    private final LoadingCache<ZoneAndId, Iterable<? extends FloatingIP>> floatingIpCache;

    @Inject
    public AllocateAndAddFloatingIpToNode(@Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, NovaApi novaApi, @Named(value="FLOATINGIP") LoadingCache<ZoneAndId, Iterable<? extends FloatingIP>> floatingIpCache) {
        this.nodeRunning = (Predicate)Preconditions.checkNotNull(nodeRunning, (Object)"nodeRunning");
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
        this.floatingIpCache = (LoadingCache)Preconditions.checkNotNull(floatingIpCache, (Object)"floatingIpCache");
    }

    public AtomicReference<NodeMetadata> apply(AtomicReference<NodeMetadata> input) {
        Preconditions.checkState((boolean)this.nodeRunning.apply(input), (String)"node never achieved state running %s", (Object[])new Object[]{input.get()});
        NodeMetadata node = input.get();
        String zoneId = node.getLocation().getParent().getId();
        FloatingIPApi floatingIpApi = (FloatingIPApi)this.novaApi.getFloatingIPExtensionForZone(zoneId).get();
        FloatingIP ip = null;
        try {
            this.logger.debug(">> allocating or reassigning floating ip for node(%s)", new Object[]{node.getId()});
            ip = floatingIpApi.create();
        }
        catch (InsufficientResourcesException e) {
            this.logger.trace("<< [%s] allocating a new floating ip for node(%s)", new Object[]{e.getMessage(), node.getId()});
            this.logger.trace(">> searching for existing, unassigned floating ip for node(%s)", new Object[]{node.getId()});
            ArrayList unassignedIps = Lists.newArrayList((Iterable)Iterables.filter(floatingIpApi.list(), (Predicate)new Predicate<FloatingIP>(){

                public boolean apply(FloatingIP arg0) {
                    return arg0.getFixedIp() == null;
                }
            }));
            Collections.shuffle(unassignedIps);
            ip = (FloatingIP)Iterables.getLast((Iterable)unassignedIps);
        }
        this.logger.debug(">> adding floatingIp(%s) to node(%s)", new Object[]{ip.getIp(), node.getId()});
        floatingIpApi.addToServer(ip.getIp(), node.getProviderId());
        input.set(NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).publicAddresses((Iterable)ImmutableSet.of((Object)ip.getIp())).build());
        this.floatingIpCache.invalidate((Object)ZoneAndId.fromSlashEncoded(node.getId()));
        return input;
    }

    public String toString() {
        return Objects.toStringHelper((String)"AllocateAndAddFloatingIpToNode").toString();
    }
}

