/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.Quota;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/quotas-sets/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/os-quota-sets")
@Beta
public interface QuotaAsyncApi {
    @GET
    @SelectJson(value="quota_set")
    @Consumes(value={"application/json"})
    @Path(value="/{tenant_id}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends Quota> getByTenant(@PathParam(value="tenant_id") String var1);

    @PUT
    @Path(value="/{tenant_id}")
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<Boolean> updateQuotaOfTenant(@PayloadParam(value="quota_set") Quota var1, @PathParam(value="tenant_id") String var2);

    @GET
    @SelectJson(value="quota_set")
    @Consumes(value={"application/json"})
    @Path(value="/{tenant_id}/defaults")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends Quota> getDefaultsForTenant(@PathParam(value="tenant_id") String var1);
}

