/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.BackupType;
import org.jclouds.openstack.nova.v2_0.functions.ParseImageIdFromLocationHeader;
import org.jclouds.openstack.nova.v2_0.options.CreateBackupOfServerOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/admin-actions/api/v1.1")
@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/servers/{id}/action")
@Beta
public interface ServerAdminAsyncApi {
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"suspend\":null}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> suspend(@PathParam(value="id") String var1);

    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"resume\":null}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> resume(@PathParam(value="id") String var1);

    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"migrate\":null}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> migrate(@PathParam(value="id") String var1);

    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"lock\":null}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> lock(@PathParam(value="id") String var1);

    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"unlock\":null}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> unlock(@PathParam(value="id") String var1);

    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"resetNetwork\":null}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> resetNetwork(@PathParam(value="id") String var1);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="createBackup")
    @ExceptionParser(value=MapHttp4xxCodesToExceptions.class)
    @ResponseParser(value=ParseImageIdFromLocationHeader.class)
    public ListenableFuture<String> createBackup(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2, @PayloadParam(value="backup_type") BackupType var3, @PayloadParam(value="rotation") int var4, CreateBackupOfServerOptions ... var5);

    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"pause\":null}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> pause(@PathParam(value="id") String var1);

    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"unpause\":null}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> unpause(@PathParam(value="id") String var1);

    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"injectNetworkInfo\":null}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> injectNetworkInfo(@PathParam(value="id") String var1);

    @POST
    @Produces(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @WrapWith(value="os-migrateLive")
    public ListenableFuture<Boolean> liveMigrate(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2, @PayloadParam(value="block_migration") boolean var3, @PayloadParam(value="disk_over_commit") boolean var4);
}

