/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.features.ImageApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseImages
extends ParseJson<Images<? extends Resource>> {
    @Inject
    public ParseImages(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<Images<? extends Resource>>(){});
    }

    public static class ToPagedIterable
    extends CallerArg0ToPagedIterable<Resource, ToPagedIterable> {
        private final NovaApi api;

        @Inject
        protected ToPagedIterable(NovaApi api) {
            this.api = (NovaApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Resource>> markerToNextForCallingArg0(String zone) {
            final ImageApi imageApi = this.api.getImageApiForZone(zone);
            return new Function<Object, IterableWithMarker<Resource>>(){

                public IterableWithMarker<Resource> apply(Object input) {
                    return (IterableWithMarker)IterableWithMarker.class.cast(imageApi.list(PaginationOptions.Builder.marker((String)input.toString())));
                }

                public String toString() {
                    return "list()";
                }
            };
        }
    }

    static class Images<T extends Resource>
    extends PaginatedCollection<T> {
        @ConstructorProperties(value={"images", "images_links"})
        protected Images(Iterable<T> images, Iterable<Link> images_links) {
            super(images, images_links);
        }
    }
}

