/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;

@Singleton
public class ParseKeyPairs
implements Function<HttpResponse, FluentIterable<? extends KeyPair>> {
    private final ParseFirstJsonValueNamed<FluentIterable<Wrapper>> parser;

    @Inject
    public ParseKeyPairs(GsonWrapper gsonView) {
        this.parser = new ParseFirstJsonValueNamed((GsonWrapper)Preconditions.checkNotNull((Object)gsonView, (Object)"gsonView"), (TypeLiteral)new TypeLiteral<FluentIterable<Wrapper>>(){}, "keypairs");
    }

    public FluentIterable<? extends KeyPair> apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        return ((FluentIterable)this.parser.apply(response)).transform(Suppliers.supplierFunction());
    }

    private static class Wrapper
    implements Supplier<KeyPair> {
        private KeyPair keypair;

        private Wrapper() {
        }

        public KeyPair get() {
            return this.keypair;
        }
    }
}

