/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.NovaAsyncApi;
import org.jclouds.openstack.nova.v2_0.compute.config.NovaComputeServiceContextModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.nova.v2_0.config.NovaRestClientModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class NovaApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 6725672099385580694L;
    public static final TypeToken<RestContext<NovaApi, NovaAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<NovaApi, NovaAsyncApi>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    public Builder toBuilder() {
        return new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public NovaApiMetadata() {
        this(new Builder());
    }

    protected NovaApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.ssh.max-retries", "7");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        properties.setProperty("jclouds.keystone.service-type", "compute");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.openstack-nova.auto-create-floating-ips", "false");
        properties.setProperty("jclouds.openstack-nova.auto-generate-keypairs", "false");
        properties.setProperty("jclouds.openstack-nova.timeout.securitygroup-present", "500");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(NovaApi.class, NovaAsyncApi.class);
            this.id("openstack-nova").name("OpenStack Nova Diablo+ API").identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant").credentialName("${password}").endpointName("KeyStone base url ending in /v2.0/").documentation(URI.create("http://api.openstack.org/")).version("1.1").defaultEndpoint("http://localhost:5000/v2.0/").defaultProperties(NovaApiMetadata.defaultProperties()).view(TypeToken.of(ComputeServiceContext.class)).defaultModules((Set)ImmutableSet.builder().add(KeystoneAuthenticationModule.class).add(KeystoneAuthenticationModule.ZoneModule.class).add(NovaParserModule.class).add(NovaRestClientModule.class).add(NovaComputeServiceContextModule.class).build());
        }

        public NovaApiMetadata build() {
            return new NovaApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

