/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.features.FlavorApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseFlavors
extends ParseJson<Flavors<? extends Resource>> {
    @Inject
    public ParseFlavors(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<Flavors<? extends Resource>>(){});
    }

    public static class ToPagedIterable
    extends CallerArg0ToPagedIterable<Resource, ToPagedIterable> {
        private final NovaApi api;

        @Inject
        protected ToPagedIterable(NovaApi api) {
            this.api = (NovaApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Resource>> markerToNextForCallingArg0(String zone) {
            final FlavorApi flavorApi = this.api.getFlavorApiForZone(zone);
            return new Function<Object, IterableWithMarker<Resource>>(){

                public IterableWithMarker<Resource> apply(Object input) {
                    return (IterableWithMarker)IterableWithMarker.class.cast(flavorApi.list(PaginationOptions.Builder.marker((String)input.toString())));
                }

                public String toString() {
                    return "listFlavors()";
                }
            };
        }
    }

    static class Flavors<T extends Resource>
    extends PaginatedCollection<T> {
        @ConstructorProperties(value={"flavors", "flavors_links"})
        protected Flavors(Iterable<T> flavors, Iterable<Link> flavors_links) {
            super(flavors, flavors_links);
        }
    }
}

