/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateVolumeOptions
implements MapBinder {
    public static final CreateVolumeOptions NONE = new CreateVolumeOptions();
    @Inject
    private BindToJsonPayload jsonBinder;
    protected String name;
    protected String description;
    protected String volumeType;
    protected String availabilityZone;
    protected String snapshotId;
    protected Map<String, String> metadata = ImmutableMap.of();

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        HashMap image = Maps.newHashMap();
        image.putAll(postParams);
        if (this.name != null) {
            image.put("display_name", this.name);
        }
        if (this.description != null) {
            image.put("display_description", this.description);
        }
        if (this.volumeType != null) {
            image.put("volume_type", this.volumeType);
        }
        if (this.availabilityZone != null) {
            image.put("availability_zone", this.availabilityZone);
        }
        if (this.snapshotId != null) {
            image.put("snapshot_id", this.snapshotId);
        }
        if (!this.metadata.isEmpty()) {
            image.put("metadata", this.metadata);
        }
        return (R)this.jsonBinder.bindToRequest(request, (Object)ImmutableMap.of((Object)"volume", (Object)image));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("CreateVolume is a POST operation");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CreateVolumeOptions)) {
            return false;
        }
        CreateVolumeOptions other = (CreateVolumeOptions)CreateVolumeOptions.class.cast(object);
        return Objects.equal((Object)this.volumeType, (Object)other.volumeType) && Objects.equal((Object)this.availabilityZone, (Object)other.availabilityZone) && Objects.equal((Object)this.snapshotId, (Object)other.snapshotId) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.description, (Object)other.description) && Objects.equal(this.metadata, other.metadata);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.volumeType, this.availabilityZone, this.snapshotId, this.name, this.description, this.metadata});
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("volumeType", (Object)this.volumeType).add("availabilityZone", (Object)this.availabilityZone).add("snapshotId", (Object)this.snapshotId).add("name", (Object)this.name).add("description", (Object)this.description).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    public CreateVolumeOptions metadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata, (Object)"metadata");
        Preconditions.checkArgument((metadata.size() <= 5 ? 1 : 0) != 0, (Object)("you cannot have more then 5 metadata values.  You specified: " + metadata.size()));
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            Preconditions.checkArgument((entry.getKey().getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of metadata key is 255 bytes.  Key specified %s is %d bytes", entry.getKey(), entry.getKey().getBytes().length));
            Preconditions.checkArgument((entry.getKey().getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of metadata value is 255 bytes.  Value specified for %s (%s) is %d bytes", entry.getKey(), entry.getValue(), entry.getValue().getBytes().length));
        }
        this.metadata = ImmutableMap.copyOf(metadata);
        return this;
    }

    public CreateVolumeOptions name(String name) {
        this.name = name;
        return this;
    }

    public CreateVolumeOptions description(String description) {
        this.description = description;
        return this;
    }

    public CreateVolumeOptions volumeType(String volumeType) {
        this.volumeType = volumeType;
        return this;
    }

    public CreateVolumeOptions availabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public CreateVolumeOptions snapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    public String getVolumeType() {
        return this.volumeType;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Builder {
        public static CreateVolumeOptions name(String name) {
            return new CreateVolumeOptions().name(name);
        }

        public static CreateVolumeOptions description(String description) {
            return new CreateVolumeOptions().description(description);
        }

        public static CreateVolumeOptions volumeType(String volumeType) {
            return new CreateVolumeOptions().volumeType(volumeType);
        }

        public static CreateVolumeOptions availabilityZone(String availabilityZone) {
            return new CreateVolumeOptions().availabilityZone(availabilityZone);
        }

        public static CreateVolumeOptions snapshotId(String snapshotId) {
            return new CreateVolumeOptions().snapshotId(snapshotId);
        }

        public static CreateVolumeOptions metadata(Map<String, String> metadata) {
            return new CreateVolumeOptions().metadata(metadata);
        }
    }
}

