/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.vcloud.compute.functions.HardwareForVApp;
import org.jclouds.vcloud.compute.functions.HardwareForVAppTemplate;
import org.jclouds.vcloud.compute.functions.ImageForVAppTemplate;
import org.jclouds.vcloud.compute.functions.VAppToNodeMetadata;
import org.jclouds.vcloud.compute.internal.VCloudTemplateBuilderImpl;
import org.jclouds.vcloud.compute.options.VCloudTemplateOptions;
import org.jclouds.vcloud.compute.strategy.VCloudComputeServiceAdapter;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.functions.VAppTemplatesInOrg;

public class VCloudComputeServiceDependenciesModule
extends AbstractModule {
    @VisibleForTesting
    public static final Map<Status, NodeState> VAPPSTATUS_TO_NODESTATE = ImmutableMap.builder().put((Object)Status.OFF, (Object)NodeState.SUSPENDED).put((Object)Status.ON, (Object)NodeState.RUNNING).put((Object)Status.RESOLVED, (Object)NodeState.PENDING).put((Object)Status.ERROR, (Object)NodeState.ERROR).put((Object)Status.UNRECOGNIZED, (Object)NodeState.UNRECOGNIZED).put((Object)Status.DEPLOYED, (Object)NodeState.PENDING).put((Object)Status.INCONSISTENT, (Object)NodeState.PENDING).put((Object)Status.UNKNOWN, (Object)NodeState.UNRECOGNIZED).put((Object)Status.MIXED, (Object)NodeState.PENDING).put((Object)Status.WAITING_FOR_INPUT, (Object)NodeState.PENDING).put((Object)Status.SUSPENDED, (Object)NodeState.SUSPENDED).put((Object)Status.UNRESOLVED, (Object)NodeState.PENDING).build();

    @Singleton
    @Provides
    protected Map<Status, NodeState> provideVAppStatusToNodeState() {
        return VAPPSTATUS_TO_NODESTATE;
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<VApp, VAppTemplate, VAppTemplate, Location>>(){}).to(VCloudComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VApp, NodeMetadata>>(){}).to(VAppToNodeMetadata.class);
        this.bind(TemplateOptions.class).to(VCloudTemplateOptions.class);
        this.bind(TemplateBuilder.class).to(VCloudTemplateBuilderImpl.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VApp, Hardware>>(){}).to((TypeLiteral)new TypeLiteral<HardwareForVApp>(){});
        this.bind((TypeLiteral)new TypeLiteral<Function<Org, Iterable<VAppTemplate>>>(){}).to(VAppTemplatesInOrg.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VAppTemplate, Image>>(){}).to(ImageForVAppTemplate.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VAppTemplate, Hardware>>(){}).to(HardwareForVAppTemplate.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Location, Location>>(){}).to(IdentityFunction.class);
    }

    @Provides
    @Singleton
    public Supplier<NetworkConfig> networkConfig(@Network Supplier<ReferenceType> network, final FenceMode defaultFenceMode) {
        return Suppliers.compose((Function)new Function<ReferenceType, NetworkConfig>(){

            public NetworkConfig apply(ReferenceType input) {
                return new NetworkConfig(input.getName(), input.getHref(), defaultFenceMode);
            }
        }, network);
    }
}

