/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.endpoints.Org;
import org.jclouds.vcloud.suppliers.OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault;

@Singleton
public class DefaultOrgForUser
implements Function<String, Supplier<ReferenceType>> {
    private final OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault selector;
    private final Supplier<VCloudSession> sessionSupplier;

    @Inject
    public DefaultOrgForUser(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, @Org Predicate<ReferenceType> defaultSelector, Supplier<VCloudSession> sessionSupplier) {
        this.selector = new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault((ValueOfConfigurationKeyOrNull)Preconditions.checkNotNull((Object)valueOfConfigurationKeyOrNull, (Object)"valueOfConfigurationKeyOrNull"), "jclouds.vcloud.defaults.org", (Predicate<ReferenceType>)((Predicate)Preconditions.checkNotNull(defaultSelector, (Object)"defaultSelector")));
        this.sessionSupplier = (Supplier)Preconditions.checkNotNull(sessionSupplier, (Object)"sessionSupplier");
    }

    public Supplier<ReferenceType> apply(final String user) {
        return Suppliers.compose((Function)new Function<VCloudSession, ReferenceType>(){

            public ReferenceType apply(VCloudSession session) {
                Preconditions.checkState((session != null ? 1 : 0) != 0, (String)"could not retrieve Session at %s", (Object[])new Object[]{user});
                return DefaultOrgForUser.this.selector.apply(session.getOrgs().values());
            }
        }, this.sessionSupplier);
    }
}

