/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.vcloud.config.DefaultCatalogForOrg;
import org.jclouds.vcloud.config.DefaultNetworkForVDC;
import org.jclouds.vcloud.config.DefaultOrgForUser;
import org.jclouds.vcloud.config.DefaultTasksListForOrg;
import org.jclouds.vcloud.config.DefaultVDCForOrg;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.Catalog;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.endpoints.Org;
import org.jclouds.vcloud.endpoints.TasksList;
import org.jclouds.vcloud.endpoints.VDC;

public class DefaultVCloudReferencesModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Org
    @Singleton
    protected Supplier<ReferenceType> provideDefaultOrg(DefaultOrgForUser defaultOrgURIForUser, @Identity String user) {
        return defaultOrgURIForUser.apply(user);
    }

    @Provides
    @Singleton
    @Org
    protected Predicate<ReferenceType> provideDefaultOrgSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @TasksList
    @Singleton
    protected Supplier<ReferenceType> provideDefaultTasksList(DefaultTasksListForOrg defaultTasksListURIForOrg, @Org Supplier<ReferenceType> defaultOrg) {
        return Suppliers.compose((Function)defaultTasksListURIForOrg, defaultOrg);
    }

    @Provides
    @Catalog
    @Singleton
    protected Supplier<ReferenceType> provideDefaultCatalog(DefaultCatalogForOrg defaultCatalogURIForOrg, @Org Supplier<ReferenceType> defaultOrg) {
        return Suppliers.compose((Function)defaultCatalogURIForOrg, defaultOrg);
    }

    @Provides
    @Singleton
    @Catalog
    protected Predicate<ReferenceType> provideDefaultCatalogSelector(Injector i) {
        return (Predicate)i.getInstance(WriteableCatalog.class);
    }

    @Provides
    @Singleton
    protected Supplier<Map<URI, org.jclouds.vcloud.domain.Catalog>> provideCatalogsById(Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.Catalog>>> supplier) {
        return Suppliers.compose((Function)new Function<Map<String, Map<String, org.jclouds.vcloud.domain.Catalog>>, Map<URI, org.jclouds.vcloud.domain.Catalog>>(){

            public Map<URI, org.jclouds.vcloud.domain.Catalog> apply(Map<String, Map<String, org.jclouds.vcloud.domain.Catalog>> arg0) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map<String, org.jclouds.vcloud.domain.Catalog> v1 : arg0.values()) {
                    for (org.jclouds.vcloud.domain.Catalog v2 : v1.values()) {
                        builder.put((Object)v2.getHref(), (Object)v2);
                    }
                }
                return builder.build();
            }
        }, supplier);
    }

    @Provides
    @VDC
    @Singleton
    protected Supplier<ReferenceType> provideDefaultVDC(DefaultVDCForOrg defaultVDCURIForOrg, @Org Supplier<ReferenceType> defaultOrg) {
        return Suppliers.compose((Function)defaultVDCURIForOrg, defaultOrg);
    }

    @Provides
    @Singleton
    @VDC
    protected Predicate<ReferenceType> provideDefaultVDCSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @Network
    @Singleton
    protected Supplier<ReferenceType> provideDefaultNetwork(DefaultNetworkForVDC defaultNetworkURIForVDC, @VDC Supplier<ReferenceType> defaultVDC) {
        return Suppliers.compose((Function)defaultNetworkURIForVDC, defaultVDC);
    }

    @Provides
    @Singleton
    @Network
    protected Predicate<ReferenceType> provideDefaultNetworkSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Singleton
    public static class WriteableCatalog
    implements Predicate<ReferenceType> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final Supplier<Map<URI, org.jclouds.vcloud.domain.Catalog>> catalogsByIdSupplier;

        @Inject
        public WriteableCatalog(Supplier<Map<URI, org.jclouds.vcloud.domain.Catalog>> catalogsByIdSupplier) {
            this.catalogsByIdSupplier = catalogsByIdSupplier;
        }

        public boolean apply(ReferenceType arg0) {
            Map index = (Map)this.catalogsByIdSupplier.get();
            org.jclouds.vcloud.domain.Catalog catalog = (org.jclouds.vcloud.domain.Catalog)index.get(arg0.getHref());
            if (catalog == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("didn't find catalog %s", new Object[]{arg0});
                }
                return false;
            }
            return !catalog.isReadOnly();
        }
    }
}

