/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.util.Iterables2;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VDC;

@Singleton
public class AllVDCsInOrg
implements Function<Org, Iterable<VDC>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    AllVDCsInOrg(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    public Iterable<VDC> apply(Org org) {
        Iterable catalogItems = FutureIterables.transformParallel(org.getVDCs().values(), (Function)new Function<ReferenceType, Future<? extends VDC>>(){

            public Future<? extends VDC> apply(ReferenceType from) {
                return AllVDCsInOrg.this.aclient.getVDCClient().getVDC(from.getHref());
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("vdcs in org " + org.getName()));
        return Iterables2.concreteCopy((Iterable)catalogItems);
    }
}

