/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;
import org.jclouds.util.Iterables2;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Org;

@Singleton
public class OrgsForLocations
implements Function<Iterable<Location>, Iterable<Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    OrgsForLocations(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    public Iterable<Org> apply(Iterable<Location> from) {
        return Iterables2.concreteCopy((Iterable)FutureIterables.transformParallel((Iterable)Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(from, (Predicate)new Predicate<Location>(){

            public boolean apply(Location input) {
                return input.getScope() == LocationScope.ZONE;
            }
        }), (Function)new Function<Location, URI>(){

            public URI apply(Location from) {
                return URI.create(from.getParent().getId());
            }
        })), (Function)new Function<URI, Future<? extends Org>>(){

            public Future<Org> apply(URI from) {
                return OrgsForLocations.this.aclient.getOrgClient().getOrg(from);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)"organizations for uris"));
    }
}

