/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.util.Iterables2;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Org;

@Singleton
public class OrgsForNames
implements Function<Iterable<String>, Iterable<Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    OrgsForNames(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    public Iterable<Org> apply(Iterable<String> from) {
        return Iterables2.concreteCopy((Iterable)FutureIterables.transformParallel(from, (Function)new Function<String, Future<? extends Org>>(){

            public Future<Org> apply(String from) {
                return OrgsForNames.this.aclient.getOrgClient().findOrgNamed(from);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)"organizations for names"));
    }
}

