/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.util.Iterables2;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class VAppTemplatesInOrg
implements Function<Org, Iterable<VAppTemplate>> {
    private final Function<Org, Iterable<CatalogItem>> allCatalogItemsInOrg;
    private final Function<Iterable<CatalogItem>, Iterable<VAppTemplate>> vAppTemplatesForCatalogItems;

    @Inject
    VAppTemplatesInOrg(Function<Org, Iterable<CatalogItem>> allCatalogItemsInOrg, Function<Iterable<CatalogItem>, Iterable<VAppTemplate>> vAppTemplatesForCatalogItems) {
        this.allCatalogItemsInOrg = allCatalogItemsInOrg;
        this.vAppTemplatesForCatalogItems = vAppTemplatesForCatalogItems;
    }

    public Iterable<VAppTemplate> apply(Org from) {
        Iterable catalogs = (Iterable)this.allCatalogItemsInOrg.apply((Object)from);
        Iterable vAppTemplates = Iterables2.concreteCopy((Iterable)((Iterable)this.vAppTemplatesForCatalogItems.apply((Object)catalogs)));
        return Iterables.filter((Iterable)vAppTemplates, (Predicate)Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<VAppTemplate>(){

            public boolean apply(VAppTemplate input) {
                if (input == null) {
                    return false;
                }
                return ImmutableSet.of((Object)((Object)Status.RESOLVED), (Object)((Object)Status.OFF)).contains((Object)input.getStatus());
            }
        }));
    }
}

