/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.domain.Credentials;

public final class TemporaryCredentials
extends Credentials {
    private final String sessionToken;
    private final Date expiration;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return TemporaryCredentials.builder().from(this);
    }

    private TemporaryCredentials(String accessKeyId, String secretAccessKey, String sessionToken, Date expiration) {
        super((String)Preconditions.checkNotNull((Object)accessKeyId, (Object)"accessKeyId"), (String)Preconditions.checkNotNull((Object)secretAccessKey, (String)"secretAccessKey for %s", (Object[])new Object[]{accessKeyId}));
        this.sessionToken = (String)Preconditions.checkNotNull((Object)sessionToken, (String)"sessionToken for %s", (Object[])new Object[]{accessKeyId});
        this.expiration = (Date)Preconditions.checkNotNull((Object)expiration, (String)"expiration for %s", (Object[])new Object[]{accessKeyId});
    }

    public String getAccessKeyId() {
        return this.identity;
    }

    public String getSecretAccessKey() {
        return this.credential;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.identity, this.credential, this.sessionToken, this.expiration});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TemporaryCredentials other = (TemporaryCredentials)((Object)obj);
        return Objects.equal((Object)this.identity, (Object)other.identity) && Objects.equal((Object)this.credential, (Object)other.credential) && Objects.equal((Object)this.sessionToken, (Object)other.sessionToken) && Objects.equal((Object)this.expiration, (Object)other.expiration);
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("accessKeyId", (Object)this.identity).add("sessionToken", (Object)this.sessionToken).add("expiration", (Object)this.expiration).toString();
    }

    public static final class Builder
    extends Credentials.Builder<TemporaryCredentials> {
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;
        private Date expiration;

        public Builder identity(String identity) {
            return this.accessKeyId(identity);
        }

        public Builder credential(String credential) {
            return this.secretAccessKey(credential);
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public Builder expiration(Date expiration) {
            this.expiration = expiration;
            return this;
        }

        public TemporaryCredentials build() {
            return new TemporaryCredentials(this.accessKeyId, this.secretAccessKey, this.sessionToken, this.expiration);
        }

        public Builder from(TemporaryCredentials in) {
            return this.accessKeyId(in.identity).secretAccessKey(in.credential).sessionToken(in.sessionToken).expiration(in.expiration);
        }
    }
}

