/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import org.jclouds.openstack.functions.ParseAuthenticationResponseFromHeaders;
import org.jclouds.rest.annotations.ResponseParser;

@Path(value="/v{jclouds.api-version}")
public interface OpenStackAuthAsyncClient {
    public static final String VERSION = "1.0";

    @GET
    @ResponseParser(value=ParseAuthenticationResponseFromHeaders.class)
    public ListenableFuture<AuthenticationResponse> authenticate(@HeaderParam(value="X-Auth-User") String var1, @HeaderParam(value="X-Auth-Key") String var2);

    @GET
    @ResponseParser(value=ParseAuthenticationResponseFromHeaders.class)
    public ListenableFuture<AuthenticationResponse> authenticateStorage(@HeaderParam(value="X-Storage-User") String var1, @HeaderParam(value="X-Storage-Pass") String var2);

    public static class AuthenticationResponse {
        private final String authToken;
        private Map<String, URI> services;

        public AuthenticationResponse(String authToken, Map<String, URI> services) {
            this.authToken = (String)Preconditions.checkNotNull((Object)authToken, (Object)"authToken");
            this.services = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(services, (Object)"services")));
        }

        public Map<String, URI> getServices() {
            return this.services;
        }

        public void setEndpoints(Map<String, URI> services) {
            this.services = services;
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.authToken, this.services});
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            return Objects.equal((Object)this.toString(), (Object)that.toString());
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("authToken", (Object)this.authToken).add("services", this.services).toString();
        }
    }
}

