/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.RetryOnTimeOutExceptionSupplier;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.RequiresHttp;
import org.jclouds.openstack.Authentication;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.rest.AsyncClientFactory;

@RequiresHttp
public class OpenStackAuthenticationModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    @Authentication
    protected Supplier<String> provideAuthenticationTokenCache(final Supplier<OpenStackAuthAsyncClient.AuthenticationResponse> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return new Supplier<String>(){

            public String get() {
                return ((OpenStackAuthAsyncClient.AuthenticationResponse)supplier.get()).getAuthToken();
            }
        };
    }

    @Provides
    @Singleton
    Supplier<OpenStackAuthAsyncClient.AuthenticationResponse> provideAuthenticationResponseCache(GetAuthenticationResponse getAuthenticationResponse) {
        return Suppliers.memoizeWithExpiration((Supplier)new RetryOnTimeOutExceptionSupplier((Supplier)getAuthenticationResponse), (long)23L, (TimeUnit)TimeUnit.HOURS);
    }

    @Provides
    @Singleton
    @TimeStamp
    protected Supplier<Date> provideCacheBusterDate() {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Date>(){

            public Date get() {
                return new Date();
            }
        }, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected OpenStackAuthAsyncClient.AuthenticationResponse provideAuthenticationResponse(Supplier<OpenStackAuthAsyncClient.AuthenticationResponse> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return (OpenStackAuthAsyncClient.AuthenticationResponse)supplier.get();
    }

    @Singleton
    public static class GetAuthenticationResponse
    implements Supplier<OpenStackAuthAsyncClient.AuthenticationResponse> {
        protected final OpenStackAuthAsyncClient client;
        protected final String user;
        protected final String key;

        @Inject
        public GetAuthenticationResponse(AsyncClientFactory factory, @Named(value="jclouds.identity") String user, @Named(value="jclouds.credential") String key) {
            this.client = (OpenStackAuthAsyncClient)factory.create(OpenStackAuthAsyncClient.class);
            this.user = user;
            this.key = key;
        }

        public OpenStackAuthAsyncClient.AuthenticationResponse get() {
            try {
                Future<OpenStackAuthAsyncClient.AuthenticationResponse> response = this.authenticate();
                return response.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                assert (false) : e;
                return null;
            }
        }

        protected Future<OpenStackAuthAsyncClient.AuthenticationResponse> authenticate() {
            return this.client.authenticate(this.user, this.key);
        }
    }
}

