/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.RetryOnTimeOutExceptionFunction;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.RequiresHttp;
import org.jclouds.location.Provider;
import org.jclouds.openstack.Authentication;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.rest.AsyncClientFactory;

@RequiresHttp
public class OpenStackAuthenticationModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<Credentials, OpenStackAuthAsyncClient.AuthenticationResponse>>(){}).to(GetAuthenticationResponse.class);
    }

    @Provides
    @Singleton
    @Authentication
    protected Supplier<String> provideAuthenticationTokenCache(final Supplier<OpenStackAuthAsyncClient.AuthenticationResponse> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return new Supplier<String>(){

            public String get() {
                return ((OpenStackAuthAsyncClient.AuthenticationResponse)supplier.get()).getAuthToken();
            }
        };
    }

    @Provides
    @Provider
    protected Credentials provideAuthenticationCredentials(@Named(value="jclouds.identity") String user, @Named(value="jclouds.credential") String key) {
        return new Credentials(user, key);
    }

    @Provides
    @Singleton
    public LoadingCache<Credentials, OpenStackAuthAsyncClient.AuthenticationResponse> provideAuthenticationResponseCache2(Function<Credentials, OpenStackAuthAsyncClient.AuthenticationResponse> getAuthenticationResponse) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build(CacheLoader.from(getAuthenticationResponse));
    }

    @Provides
    @Singleton
    protected Supplier<OpenStackAuthAsyncClient.AuthenticationResponse> provideAuthenticationResponseSupplier(final LoadingCache<Credentials, OpenStackAuthAsyncClient.AuthenticationResponse> cache, final @Provider Credentials creds) {
        return new Supplier<OpenStackAuthAsyncClient.AuthenticationResponse>(){

            public OpenStackAuthAsyncClient.AuthenticationResponse get() {
                try {
                    return (OpenStackAuthAsyncClient.AuthenticationResponse)cache.get((Object)creds);
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate((Throwable)e.getCause());
                }
            }
        };
    }

    @Provides
    @Singleton
    @TimeStamp
    protected Supplier<Date> provideCacheBusterDate() {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Date>(){

            public Date get() {
                return new Date();
            }
        }, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected OpenStackAuthAsyncClient.AuthenticationResponse provideAuthenticationResponse(Supplier<OpenStackAuthAsyncClient.AuthenticationResponse> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return (OpenStackAuthAsyncClient.AuthenticationResponse)supplier.get();
    }

    @Singleton
    public static class GetAuthenticationResponse
    extends RetryOnTimeOutExceptionFunction<Credentials, OpenStackAuthAsyncClient.AuthenticationResponse> {
        @Inject
        public GetAuthenticationResponse(final AsyncClientFactory factory) {
            super((Function)new Function<Credentials, OpenStackAuthAsyncClient.AuthenticationResponse>(){

                public OpenStackAuthAsyncClient.AuthenticationResponse apply(Credentials input) {
                    try {
                        ListenableFuture<OpenStackAuthAsyncClient.AuthenticationResponse> response = ((OpenStackAuthAsyncClient)factory.create(OpenStackAuthAsyncClient.class)).authenticate(input.identity, input.credential);
                        return (OpenStackAuthAsyncClient.AuthenticationResponse)response.get(30L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }

                public String toString() {
                    return "authenticate()";
                }
            });
        }
    }
}

