/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.concurrent.RetryOnTimeOutExceptionFunction;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.Authentication;
import org.jclouds.openstack.keystone.v1_1.ServiceAsyncClient;
import org.jclouds.openstack.keystone.v1_1.ServiceClient;
import org.jclouds.openstack.keystone.v1_1.domain.Auth;
import org.jclouds.openstack.keystone.v1_1.handlers.RetryOnRenew;
import org.jclouds.openstack.keystone.v1_1.suppliers.RegionIdToURIFromAuthForServiceSupplier;
import org.jclouds.rest.config.BinderUtils;

@RequiresHttp
public class AuthenticationServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<Credentials, Auth>>(){}).to(GetAuth.class);
        BinderUtils.bindClientAndAsyncClient((Binder)this.binder(), ServiceClient.class, ServiceAsyncClient.class);
        this.install(new FactoryModuleBuilder().implement(RegionIdToURISupplier.class, RegionIdToURIFromAuthForServiceSupplier.class).build(RegionIdToURISupplier.Factory.class));
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
    }

    @Provides
    @Singleton
    @Authentication
    protected Supplier<String> provideAuthenticationTokenCache(final Supplier<Auth> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return new Supplier<String>(){

            public String get() {
                return ((Auth)supplier.get()).getToken().getId();
            }
        };
    }

    @Provides
    @Singleton
    public LoadingCache<Credentials, Auth> provideAuthCache(Function<Credentials, Auth> getAuth) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build(CacheLoader.from(getAuth));
    }

    @Provides
    @Singleton
    protected Supplier<Auth> provideAuthSupplier(final LoadingCache<Credentials, Auth> cache, final @Provider Credentials creds) {
        return new Supplier<Auth>(){

            public Auth get() {
                try {
                    return (Auth)cache.get((Object)creds);
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate((Throwable)e.getCause());
                }
            }
        };
    }

    @Singleton
    public static class GetAuth
    extends RetryOnTimeOutExceptionFunction<Credentials, Auth> {
        @Inject
        public GetAuth(final ServiceClient client) {
            super((Function)new Function<Credentials, Auth>(){

                public Auth apply(Credentials input) {
                    return client.authenticate(input.identity, input.credential);
                }

                public String toString() {
                    return "authenticate()";
                }
            });
        }
    }
}

