/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.openstack.keystone.v2_0.ServiceClient;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.ApiAccessKeyCredentials;
import org.jclouds.rest.AuthorizationException;

@Singleton
public class AuthenticateApiAccessKeyCredentials
implements Function<Credentials, Access> {
    private final ServiceClient client;

    @Inject
    public AuthenticateApiAccessKeyCredentials(ServiceClient client) {
        this.client = client;
    }

    public Access apply(Credentials input) {
        if (input.identity.indexOf(58) == -1) {
            throw new AuthorizationException(String.format("Identity %s does not match format tenantId:accesskey", input.identity), null);
        }
        String tenantId = input.identity.substring(0, input.identity.indexOf(58));
        String usernameOrAccessKey = input.identity.substring(input.identity.indexOf(58) + 1);
        String passwordOrSecretKey = input.credential;
        ApiAccessKeyCredentials apiAccessKeyCredentials = ApiAccessKeyCredentials.createWithAccessKeyAndSecretKey(usernameOrAccessKey, passwordOrSecretKey);
        return this.client.authenticateTenantWithCredentials(tenantId, apiAccessKeyCredentials);
    }

    public String toString() {
        return "authenticateApiAccessKeyCredentials()";
    }
}

