/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.domain.Link;

public class Resource
implements Comparable<Resource> {
    protected final String id;
    protected final String name;
    protected final Set<Link> links;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Resource.builder().fromResource(this);
    }

    public Resource(String id, @Nullable String name, Set<Link> links) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = name;
        this.links = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(links, (Object)"links")));
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public Set<Link> getLinks() {
        return this.links;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Resource) {
            Resource other = (Resource)Resource.class.cast(object);
            return Objects.equal((Object)this.getId(), (Object)other.getId()) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.links, other.links);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.name, this.links});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.getId()).add("name", (Object)this.name).add("links", this.links);
    }

    @Override
    public int compareTo(Resource that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getId().compareTo(that.getId());
    }

    public static class Builder {
        protected String id;
        protected String name;
        protected Set<Link> links = ImmutableSet.of();

        public Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder links(Link ... links) {
            return this.links((Set<Link>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)links, (Object)"links"))));
        }

        public Builder links(Set<Link> links) {
            this.links = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(links, (Object)"links")));
            return this;
        }

        public Resource build() {
            return new Resource(this.id, this.name, this.links);
        }

        public Builder fromResource(Resource from) {
            return this.id(from.getId()).name(from.getName()).links(from.getLinks());
        }
    }
}

