/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;

public class Endpoint
implements Comparable<Endpoint> {
    protected final boolean v1Default;
    protected final String region;
    protected final URI publicURL;
    protected final URI internalURL;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Endpoint.builder().fromEndpoint(this);
    }

    protected Endpoint(boolean v1Default, @Nullable String region, @Nullable URI publicURL, @Nullable URI internalURL) {
        this.v1Default = v1Default;
        this.region = region;
        this.publicURL = publicURL;
        this.internalURL = internalURL;
    }

    public boolean isV1Default() {
        return this.v1Default;
    }

    @Nullable
    public String getRegion() {
        return this.region;
    }

    @Nullable
    public URI getPublicURL() {
        return this.publicURL;
    }

    @Nullable
    public URI getInternalURL() {
        return this.internalURL;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Endpoint) {
            Endpoint other = (Endpoint)Endpoint.class.cast(object);
            return Objects.equal((Object)this.v1Default, (Object)other.v1Default) && Objects.equal((Object)this.region, (Object)other.region) && Objects.equal((Object)this.publicURL, (Object)other.publicURL) && Objects.equal((Object)this.internalURL, (Object)other.internalURL);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.v1Default, this.region, this.publicURL, this.internalURL});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("v1Default", this.v1Default).add("region", (Object)this.region).add("publicURL", (Object)this.publicURL).add("internalURL", (Object)this.internalURL).toString();
    }

    @Override
    public int compareTo(Endpoint that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.publicURL.compareTo(that.publicURL);
    }

    public static class Builder {
        protected boolean v1Default;
        protected String region;
        protected URI publicURL;
        protected URI internalURL;

        public Builder v1Default(boolean v1Default) {
            this.v1Default = v1Default;
            return this;
        }

        public Builder region(String region) {
            this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
            return this;
        }

        public Builder publicURL(URI publicURL) {
            this.publicURL = (URI)Preconditions.checkNotNull((Object)publicURL, (Object)"publicURL");
            return this;
        }

        public Builder internalURL(@Nullable URI internalURL) {
            this.internalURL = internalURL;
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.v1Default, this.region, this.publicURL, this.internalURL);
        }

        public Builder fromEndpoint(Endpoint from) {
            return this.v1Default(from.isV1Default()).region(from.getRegion()).publicURL(from.getPublicURL()).internalURL(from.getInternalURL());
        }
    }
}

