/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;

public class Endpoint
implements Comparable<Endpoint> {
    @Deprecated
    protected String id;
    protected final String versionId;
    protected final String region;
    protected final URI publicURL;
    protected final URI internalURL;
    @Deprecated
    protected String tenantName;
    protected final String tenantId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Endpoint.builder().fromEndpoint(this);
    }

    protected Endpoint(String versionId, String region, @Nullable URI publicURL, @Nullable URI internalURL, @Nullable String tenantId) {
        this.versionId = (String)Preconditions.checkNotNull((Object)versionId, (Object)"versionId");
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.publicURL = publicURL;
        this.internalURL = internalURL;
        this.tenantId = tenantId;
    }

    public String getVersionId() {
        return this.versionId != null ? this.versionId : this.id;
    }

    public String getRegion() {
        return this.region;
    }

    @Nullable
    public URI getPublicURL() {
        return this.publicURL;
    }

    @Nullable
    public URI getInternalURL() {
        return this.internalURL;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId != null ? this.tenantId : this.tenantName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Endpoint) {
            Endpoint other = (Endpoint)Endpoint.class.cast(object);
            return Objects.equal((Object)this.getVersionId(), (Object)other.getVersionId()) && Objects.equal((Object)this.region, (Object)other.region) && Objects.equal((Object)this.publicURL, (Object)other.publicURL) && Objects.equal((Object)this.internalURL, (Object)other.internalURL) && Objects.equal((Object)this.getTenantId(), (Object)other.getTenantId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getVersionId(), this.region, this.publicURL, this.internalURL, this.getTenantId()});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("versionId", (Object)this.getVersionId()).add("region", (Object)this.region).add("publicURL", (Object)this.publicURL).add("internalURL", (Object)this.internalURL).add("tenantId", (Object)this.getTenantId()).toString();
    }

    @Override
    public int compareTo(Endpoint that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.getTenantId()), (Comparable)((Object)that.getTenantId())).compare((Comparable)((Object)this.getVersionId()), (Comparable)((Object)that.getVersionId())).compare((Comparable)((Object)this.region), (Comparable)((Object)that.region)).result();
    }

    public static class Builder {
        protected String versionId;
        protected String region;
        protected URI publicURL;
        protected URI internalURL;
        protected String tenantId;

        public Builder versionId(String versionId) {
            this.versionId = (String)Preconditions.checkNotNull((Object)versionId, (Object)"versionId");
            return this;
        }

        public Builder region(String region) {
            this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
            return this;
        }

        public Builder publicURL(URI publicURL) {
            this.publicURL = (URI)Preconditions.checkNotNull((Object)publicURL, (Object)"publicURL");
            return this;
        }

        public Builder internalURL(URI internalURL) {
            this.internalURL = (URI)Preconditions.checkNotNull((Object)internalURL, (Object)"internalURL");
            return this;
        }

        public Builder tenantId(@Nullable String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.versionId, this.region, this.publicURL, this.internalURL, this.tenantId);
        }

        public Builder fromEndpoint(Endpoint from) {
            return this.versionId(from.getVersionId()).region(from.getRegion()).publicURL(from.getPublicURL()).internalURL(from.getInternalURL()).tenantId(from.getTenantId());
        }
    }
}

