/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;

public class Service
implements Comparable<Service> {
    protected final String type;
    protected final String name;
    protected final Set<Endpoint> endpoints;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Service.builder().fromService(this);
    }

    public Service(String type, String name, Set<Endpoint> endpoints) {
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.endpoints = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(endpoints, (Object)"endpoints")));
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Service) {
            Service other = (Service)Service.class.cast(object);
            return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.endpoints, other.endpoints);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.name, this.endpoints});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("type", (Object)this.type).add("name", (Object)this.name).add("endpoints", this.endpoints).toString();
    }

    @Override
    public int compareTo(Service that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.type.compareTo(that.type);
    }

    public static class Builder {
        protected String type;
        protected String name;
        protected Set<Endpoint> endpoints = ImmutableSet.of();

        public Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            return this;
        }

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder endpoints(Endpoint ... endpoints) {
            return this.endpoints((Set<Endpoint>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)endpoints, (Object)"endpoints"))));
        }

        public Builder endpoints(Set<Endpoint> endpoints) {
            this.endpoints = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(endpoints, (Object)"endpoints")));
            return this;
        }

        public Service build() {
            return new Service(this.type, this.name, this.endpoints);
        }

        public Builder fromService(Service from) {
            return this.type(from.getType()).name(from.getName()).endpoints(from.getEndpoints());
        }
    }
}

