/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;

public class Link {
    @SerializedName(value="rel")
    protected final Relation relation;
    protected final String type;
    protected final URI href;

    public static Link create(Relation relation, URI href) {
        return new Link(relation, null, href);
    }

    public static Link create(Relation relation, String type, URI href) {
        return new Link(relation, type, href);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Link.builder().fromLink(this);
    }

    protected Link(Relation relation, @Nullable String type, URI href) {
        this.relation = (Relation)((Object)Preconditions.checkNotNull((Object)((Object)relation), (Object)"relation"));
        this.type = type;
        this.href = (URI)Preconditions.checkNotNull((Object)href, (Object)"href");
    }

    public Relation getRelation() {
        return this.relation;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public URI getHref() {
        return this.href;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Link) {
            Link other = (Link)Link.class.cast(object);
            return Objects.equal((Object)((Object)this.relation), (Object)((Object)other.relation)) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.href, (Object)other.href);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.relation, this.type, this.href});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("relation", (Object)this.relation).add("type", (Object)this.type).add("href", (Object)this.href).toString();
    }

    public static class Builder {
        protected Relation relation;
        protected String type;
        protected URI href;

        public Builder relation(Relation relation) {
            this.relation = (Relation)((Object)Preconditions.checkNotNull((Object)((Object)relation), (Object)"relation"));
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder href(URI href) {
            this.href = (URI)Preconditions.checkNotNull((Object)href, (Object)"href");
            return this;
        }

        public Link build() {
            return new Link(this.relation, this.type, this.href);
        }

        public Builder fromLink(Link from) {
            return this.relation(from.getRelation()).type(from.getType()).href(from.getHref());
        }
    }

    public static enum Relation {
        SELF,
        BOOKMARK,
        DESCRIBEDBY,
        ALTERNATE,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static Relation fromValue(String v) {
            try {
                return Relation.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

