/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.RetryOnTimeOutExceptionFunction;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.location.suppliers.RegionIdsSupplier;
import org.jclouds.location.suppliers.ZoneIdToURISupplier;
import org.jclouds.location.suppliers.ZoneIdsSupplier;
import org.jclouds.location.suppliers.derived.RegionIdsFromRegionIdToURIKeySet;
import org.jclouds.location.suppliers.derived.ZoneIdsFromZoneIdToURIKeySet;
import org.jclouds.openstack.Authentication;
import org.jclouds.openstack.keystone.v2_0.ServiceAsyncClient;
import org.jclouds.openstack.keystone.v2_0.ServiceClient;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.functions.AuthenticateApiAccessKeyCredentials;
import org.jclouds.openstack.keystone.v2_0.functions.AuthenticatePasswordCredentials;
import org.jclouds.openstack.keystone.v2_0.handlers.RetryOnRenew;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToURIFromAccessForTypeAndVersionSupplier;
import org.jclouds.openstack.keystone.v2_0.suppliers.ZoneIdToURIFromAccessForTypeAndVersionSupplier;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.BinderUtils;

@RequiresHttp
public class KeystoneAuthenticationModule
extends AbstractModule {
    private final Module locationModule;

    public KeystoneAuthenticationModule() {
        this((Module)new RegionModule());
    }

    protected KeystoneAuthenticationModule(Module locationModule) {
        this.locationModule = locationModule;
    }

    public static Module forRegions() {
        return new KeystoneAuthenticationModule((Module)new RegionModule());
    }

    public static Module forZones() {
        return new KeystoneAuthenticationModule((Module)new ZoneModule());
    }

    protected void configure() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
        this.bind(CredentialType.class).toProvider(CredentialTypeFromPropertyOrDefault.class);
        BinderUtils.bindClientAndAsyncClient((Binder)this.binder(), ServiceClient.class, ServiceAsyncClient.class);
        this.install(this.locationModule);
    }

    @Provides
    @Singleton
    @Authentication
    protected Supplier<String> provideAuthenticationTokenCache(final Supplier<Access> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return new Supplier<String>(){

            public String get() {
                return ((Access)supplier.get()).getToken().getId();
            }
        };
    }

    @Provides
    @Singleton
    protected Function<Credentials, Access> authenticationMethodForCredentialType(CredentialType credentialType, AuthenticatePasswordCredentials authenticatePasswordCredentials, AuthenticateApiAccessKeyCredentials authenticateApiAccessKeyCredentials) {
        Object authMethod;
        switch (credentialType) {
            case PASSWORD_CREDENTIALS: {
                authMethod = authenticatePasswordCredentials;
                break;
            }
            case API_ACCESS_KEY_CREDENTIALS: {
                authMethod = authenticateApiAccessKeyCredentials;
                break;
            }
            default: {
                throw new IllegalArgumentException("credential type not supported: " + (Object)((Object)credentialType));
            }
        }
        return new RetryOnTimeOutExceptionFunction((Function)authMethod);
    }

    @Provides
    @Singleton
    public LoadingCache<Credentials, Access> provideAccessCache(Function<Credentials, Access> getAccess) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build(CacheLoader.from(getAccess));
    }

    @Provides
    @Singleton
    protected Supplier<Access> provideAccessSupplier(final LoadingCache<Credentials, Access> cache, final @Provider Credentials creds) {
        return new Supplier<Access>(){

            public Access get() {
                try {
                    return (Access)cache.get((Object)creds);
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate((Throwable)e.getCause());
                }
            }
        };
    }

    @Singleton
    static class CredentialTypeFromPropertyOrDefault
    implements javax.inject.Provider<CredentialType> {
        @Inject(optional=true)
        @Named(value="jclouds.keystone.credential-type")
        String credentialType = CredentialType.PASSWORD_CREDENTIALS.toString();

        CredentialTypeFromPropertyOrDefault() {
        }

        public CredentialType get() {
            return CredentialType.fromValue(this.credentialType);
        }
    }

    public static class ZoneModule
    extends AbstractModule {
        protected void configure() {
            this.install(new FactoryModuleBuilder().implement(ZoneIdToURISupplier.class, ZoneIdToURIFromAccessForTypeAndVersionSupplier.class).build(ZoneIdToURISupplier.Factory.class));
            this.bind(ZoneIdsSupplier.class).to(ZoneIdsFromZoneIdToURIKeySet.class);
        }

        @Provides
        @Singleton
        protected ZoneIdToURISupplier provideZoneIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, ZoneIdToURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }
    }

    public static class RegionModule
    extends AbstractModule {
        protected void configure() {
            this.install(new FactoryModuleBuilder().implement(RegionIdToURISupplier.class, RegionIdToURIFromAccessForTypeAndVersionSupplier.class).build(RegionIdToURISupplier.Factory.class));
            this.bind(RegionIdsSupplier.class).to(RegionIdsFromRegionIdToURIKeySet.class);
        }

        @Provides
        @Singleton
        protected RegionIdToURISupplier provideRegionIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }
    }
}

