/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;

public class Access
implements Comparable<Access> {
    protected Token token;
    protected User user;
    protected Set<Service> serviceCatalog = ImmutableSet.of();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Access.builder().fromAccess(this);
    }

    protected Access() {
    }

    public Access(Token token, User user, Set<Service> serviceCatalog) {
        this.token = (Token)Preconditions.checkNotNull((Object)token, (Object)"token");
        this.user = (User)Preconditions.checkNotNull((Object)user, (Object)"user");
        this.serviceCatalog = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(serviceCatalog, (Object)"serviceCatalog")));
    }

    public Token getToken() {
        return this.token;
    }

    public User getUser() {
        return this.user;
    }

    public Set<Service> getServiceCatalog() {
        return this.serviceCatalog;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Access) {
            Access other = (Access)Access.class.cast(object);
            return Objects.equal((Object)this.token, (Object)other.token) && Objects.equal((Object)this.user, (Object)other.user) && Objects.equal(this.serviceCatalog, other.serviceCatalog);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.token, this.user, this.serviceCatalog});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("token", (Object)this.token).add("user", (Object)this.user).add("serviceCatalog", this.serviceCatalog).toString();
    }

    @Override
    public int compareTo(Access that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.token.compareTo(that.token);
    }

    public static class Builder {
        protected Token token;
        protected User user;
        protected Set<Service> serviceCatalog = ImmutableSet.of();

        public Builder token(Token token) {
            this.token = (Token)Preconditions.checkNotNull((Object)token, (Object)"token");
            return this;
        }

        public Builder user(User user) {
            this.user = (User)Preconditions.checkNotNull((Object)user, (Object)"user");
            return this;
        }

        public Builder serviceCatalog(Service ... serviceCatalog) {
            return this.serviceCatalog((Set<Service>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)serviceCatalog, (Object)"serviceCatalog"))));
        }

        public Builder serviceCatalog(Set<Service> serviceCatalog) {
            this.serviceCatalog = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(serviceCatalog, (Object)"serviceCatalog")));
            return this;
        }

        public Access build() {
            return new Access(this.token, this.user, this.serviceCatalog);
        }

        public Builder fromAccess(Access from) {
            return this.token(from.getToken()).user(from.getUser()).serviceCatalog(from.getServiceCatalog());
        }
    }
}

