/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class ApiAccessKeyCredentials {
    protected final String accessKey;
    protected final String secretKey;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ApiAccessKeyCredentials.builder().fromSecretKeyCredentials(this);
    }

    public static ApiAccessKeyCredentials createWithAccessKeyAndSecretKey(String accessKey, String secretKey) {
        return ApiAccessKeyCredentials.builder().secretKey(secretKey).accessKey(accessKey).build();
    }

    protected ApiAccessKeyCredentials(String accessKey, String secretKey) {
        this.accessKey = (String)Preconditions.checkNotNull((Object)accessKey, (Object)"accessKey");
        this.secretKey = (String)Preconditions.checkNotNull((Object)secretKey, (Object)"secretKey");
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ApiAccessKeyCredentials) {
            ApiAccessKeyCredentials other = (ApiAccessKeyCredentials)ApiAccessKeyCredentials.class.cast(object);
            return Objects.equal((Object)this.accessKey, (Object)other.accessKey) && Objects.equal((Object)this.secretKey, (Object)other.secretKey);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accessKey, this.secretKey});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("accessKey", (Object)this.accessKey).add("secretKey", (Object)this.secretKey).toString();
    }

    public static class Builder {
        protected String accessKey;
        protected String secretKey;

        protected Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public ApiAccessKeyCredentials build() {
            return new ApiAccessKeyCredentials(this.accessKey, this.secretKey);
        }

        public Builder fromSecretKeyCredentials(ApiAccessKeyCredentials from) {
            return this.accessKey(from.getAccessKey()).secretKey(from.getSecretKey());
        }
    }
}

