/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import org.jclouds.javax.annotation.Nullable;

public class MediaType {
    private String base;
    private String type;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return MediaType.builder().fromMediaType(this);
    }

    protected MediaType() {
    }

    protected MediaType(Builder builder) {
        this.base = builder.base;
        this.type = builder.type;
    }

    @Nullable
    public String getBase() {
        return this.base;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.base, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MediaType that = (MediaType)MediaType.class.cast(obj);
        return Objects.equal((Object)this.base, (Object)that.base) && Objects.equal((Object)this.type, (Object)that.type);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("base", (Object)this.base).add("type", (Object)this.type);
    }

    public String toString() {
        return this.string().toString();
    }

    public static class Builder {
        private String base;
        private String type;

        public Builder base(String base) {
            this.base = base;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public MediaType build() {
            return new MediaType(this);
        }

        public Builder fromMediaType(MediaType in) {
            return this.base(in.getBase()).type(in.getType());
        }
    }
}

