/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import org.jclouds.javax.annotation.Nullable;

public class Role
implements Comparable<Role> {
    protected String id;
    protected String name;
    protected String serviceId;
    @Deprecated
    protected String tenantName;
    protected String tenantId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Role.builder().fromRole(this);
    }

    protected Role() {
    }

    protected Role(String id, String name, @Nullable String serviceId, @Nullable String tenantId) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.serviceId = serviceId;
        this.tenantId = tenantId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getServiceId() {
        return this.serviceId;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId != null ? this.tenantId : this.tenantName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Role) {
            Role other = (Role)Role.class.cast(object);
            return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.serviceId, (Object)other.serviceId) && Objects.equal((Object)this.getTenantId(), (Object)other.getTenantId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.serviceId, this.getTenantId()});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("name", (Object)this.name).add("serviceId", (Object)this.serviceId).add("tenantId", (Object)this.getTenantId()).toString();
    }

    @Override
    public int compareTo(Role that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.id), (Comparable)((Object)that.id)).result();
    }

    public static class Builder {
        protected String id;
        protected String name;
        protected String serviceId;
        protected String tenantId;

        public Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder serviceId(@Nullable String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder tenantId(@Nullable String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Role build() {
            return new Role(this.id, this.name, this.serviceId, this.tenantId);
        }

        public Builder fromRole(Role from) {
            return this.id(from.getId()).name(from.getName()).serviceId(from.getServiceId()).tenantId(from.getTenantId());
        }
    }
}

