/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;

public class Tenant
implements Comparable<Tenant> {
    protected String id;
    protected String name;
    protected String description;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Tenant.builder().fromTenant(this);
    }

    protected Tenant() {
    }

    protected Tenant(String id, String name, String description) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Tenant) {
            Tenant other = (Tenant)Tenant.class.cast(object);
            return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.description, (Object)other.description);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.description});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).toString();
    }

    @Override
    public int compareTo(Tenant that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public static class Builder {
        protected String id;
        protected String name;
        protected String description;

        public Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Tenant build() {
            return new Tenant(this.id, this.name, this.description);
        }

        public Builder fromTenant(Tenant from) {
            return this.id(from.getId()).name(from.getName());
        }
    }
}

